/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.hflame;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static Document newDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseFromResource(String path) throws FileNotFoundException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Unable locate resource: " + path);
        }
        InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF8"));
        return XmlUtil.parse(reader);
    }

    public static Document parse(Reader reader) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Element> elementsOf(Element el) {
        ArrayList<Element> r = new ArrayList<Element>();
        NodeList nl = el.getChildNodes();
        for (int i = 0; i != nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            r.add((Element)n);
        }
        return r;
    }

    public static List<Text> textOf(Element el) {
        ArrayList<Text> r = new ArrayList<Text>();
        NodeList nl = el.getChildNodes();
        for (int i = 0; i != nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            r.add((Text)n);
        }
        return r;
    }

    public static String id(Element el) {
        return XmlUtil.attr(el, "id");
    }

    public static String href(Element el) {
        return XmlUtil.attr(el, "src", "href");
    }

    public static boolean isStyleSheet(Element el) {
        if (el.getNodeName().equalsIgnoreCase("link")) {
            return "stylesheet".equalsIgnoreCase(XmlUtil.attr(el, "rel"));
        }
        return el.getNodeName().equalsIgnoreCase("style");
    }

    public static boolean isScript(Element el) {
        return el.getNodeName().equalsIgnoreCase("script");
    }

    public static String attr(Element el, String ... attr) {
        NamedNodeMap nnm = el.getAttributes();
        for (int i = 0; i != nnm.getLength(); ++i) {
            Node node = nnm.item(i);
            if (!(node instanceof Attr)) continue;
            Attr a = (Attr)node;
            for (String at : attr) {
                if (!a.getName().equalsIgnoreCase(at)) continue;
                return a.getValue();
            }
        }
        return null;
    }
}

