/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.stacktrace.analytics.ClassificatorAST;
import org.gridkit.jvmtool.stacktrace.util.IndentParser;

public abstract class AbstractClassificatorParser
extends IndentParser {
    private static boolean diag = false;
    private static final String CAT_NAME = "\\[(.*)\\]";
    private static final String SUBCLASS_NAME = "\\+(.*)";
    private static final String FRAME_PATTERN = "([^!]+)";
    private Matcher tokenMatcher;
    private ARoot result;

    protected ARoot getRoot() {
        return this.result;
    }

    @Override
    protected void initialState() {
        RootSS root = new RootSS();
        this.result = root.root;
        this.pushState(root);
    }

    private void pushState(SyntaticState ss) {
        if (!(ss instanceof RootSS)) {
            this.pushParseState();
        }
        ss.initState();
        this.pushValue(ss);
        if (diag) {
            System.err.println(">> " + ss.getClass().getSimpleName());
        }
    }

    protected void replaceState(SyntaticState ss) {
        Object prev = this.popValue();
        this.unexpectAll();
        if (diag) {
            System.err.println("<< " + prev.getClass().getSimpleName() + " >> " + ss.getClass().getSimpleName());
        }
        ss.initState();
        this.pushValue(ss);
    }

    @Override
    protected void onToken(String tokenType, String token) throws IndentParser.ParseException {
        this.dispatchTokenByValue(tokenType, token);
    }

    private void matchToken(String tokenType, String token, String pattern) {
        Pattern ptr = Pattern.compile(pattern);
        this.tokenMatcher = ptr.matcher(token);
        if (!this.tokenMatcher.matches()) {
            throw new IllegalArgumentException("Token doesn't match pattern: " + token);
        }
    }

    private void dispatchTokenByValue(String tokenType, String token) throws IndentParser.ParseException {
        try {
            SyntaticState state = (SyntaticState)this.value();
            String name = "onToken" + tokenType;
            Method m = state.getClass().getMethod(name, new Class[0]);
            String pattern = m.getAnnotation(Token.class).value();
            this.matchToken(tokenType, token, pattern);
            m.setAccessible(true);
            m.invoke((Object)state, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IndentParser.ParseException) {
                throw (IndentParser.ParseException)e.getCause();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void onPopup() throws IndentParser.ParseException {
        try {
            SyntaticState state = (SyntaticState)this.value();
            this.popValue();
            this.popParseState();
            if (diag) {
                System.err.println("<< " + state.getClass().getSimpleName());
            }
            String name = "onPopup";
            Method m = state.getClass().getMethod(name, new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)state, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IndentParser.ParseException) {
                throw (IndentParser.ParseException)e.getCause();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract ARoot newRootNode();

    protected abstract AClassification newClassificationNode(String var1);

    protected abstract void addToRoot(ARoot var1, AClassification var2);

    protected abstract void addSubclass(AClassification var1, String var2, ClassificatorAST.Filter var3);

    protected static interface AClassification {
        public void setRootFilter(ClassificatorAST.Filter var1);
    }

    protected static interface ARoot {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Token {
        public String value();
    }

    class PositionedFilterSS
    extends FilterSS {
        PositionedPredicate pred;
        List<ClassificatorAST.Filter> filters;

        public PositionedFilterSS(PositionedPredicate pred) {
            this.filters = new ArrayList<ClassificatorAST.Filter>();
            this.pred = pred;
        }

        @Override
        protected void push(ClassificatorAST.Filter filter) throws IndentParser.ParseException {
            this.filters.add(filter);
        }

        public void onPopup() throws IndentParser.ParseException {
            if (this.filters.isEmpty()) {
                AbstractClassificatorParser.this.error("Empty condition");
                return;
            }
            this.pred.finish(ClassificatorAST.disjunction(this.filters));
        }
    }

    class LastFrameSS
    extends SyntaticState
    implements PositionedPredicate {
        FilterSS parent;
        List<ClassificatorAST.FrameMatcher> frames;
        boolean followed;
        boolean done;

        public LastFrameSS(FilterSS parent) {
            this.frames = new ArrayList<ClassificatorAST.FrameMatcher>();
            this.parent = parent;
        }

        @Override
        public void initState() {
            super.initState();
        }

        @Token(value="([^!]+)")
        public void onTokenPattern() throws IndentParser.ParseException {
            String p = AbstractClassificatorParser.this.tokenMatcher.group(1);
            ClassificatorAST.PatternFilter f = new ClassificatorAST.PatternFilter();
            f.patterns.add(p);
            AbstractClassificatorParser.this.pushState(new PopupOnlySS());
            this.frames.add(f);
        }

        @Token(value="!FOLLOWED")
        public void onTokenFollowed() throws IndentParser.ParseException {
            this.followed = true;
            if (this.frames.isEmpty()) {
                AbstractClassificatorParser.this.error("No frames to match");
            }
            PositionedFilterSS ss = new PositionedFilterSS(this);
            AbstractClassificatorParser.this.replaceState(ss);
        }

        @Token(value="!NOT\\s+FOLLOWED")
        public void onTokenNotFollowed() throws IndentParser.ParseException {
            this.followed = false;
            if (this.frames.isEmpty()) {
                AbstractClassificatorParser.this.error("No frames to match");
            }
            PositionedFilterSS ss = new PositionedFilterSS(this);
            AbstractClassificatorParser.this.replaceState(ss);
        }

        @Override
        public void finish(ClassificatorAST.Filter filter) throws IndentParser.ParseException {
            this.done = true;
            if (this.followed) {
                ClassificatorAST.LastFollowedFilter lff = new ClassificatorAST.LastFollowedFilter();
                lff.snippet = this.frames.size() == 1 ? this.frames.get(0) : new ClassificatorAST.AnyOfFrameMatcher(this.frames);
                lff.followFilter = filter;
                this.parent.push(lff);
            } else {
                ClassificatorAST.LastNotFollowedFilter lff = new ClassificatorAST.LastNotFollowedFilter();
                lff.snippet = this.frames.size() == 1 ? this.frames.get(0) : new ClassificatorAST.AnyOfFrameMatcher(this.frames);
                lff.followFilter = filter;
                this.parent.push(lff);
            }
        }
    }

    static interface PositionedPredicate {
        public void finish(ClassificatorAST.Filter var1) throws IndentParser.ParseException;
    }

    class SubclassSS
    extends FilterSS {
        ClassificationSS parent;
        String name;
        List<ClassificatorAST.Filter> filters;
        int line;
        int pos;

        public SubclassSS(String name, ClassificationSS parent) {
            this.filters = new ArrayList<ClassificatorAST.Filter>();
            this.name = name;
            this.parent = parent;
            this.line = AbstractClassificatorParser.this.getLineNumber();
            this.pos = AbstractClassificatorParser.this.getIndent();
        }

        @Token(value="\\[(.*)\\]")
        public void onTokenCategory() throws IndentParser.ParseException {
            this.popupState();
            this.parent.onTokenCategory();
        }

        @Token(value="\\+(.*)")
        public void onTokenSubclass() throws IndentParser.ParseException {
            this.popupState();
            this.parent.onTokenSubclass();
        }

        @Override
        protected void push(ClassificatorAST.Filter filter) {
            this.filters.add(filter);
        }

        public void onPopup() throws IndentParser.ParseException {
            AClassification cls = this.parent.classification;
            ClassificatorAST.Filter filter = ClassificatorAST.conjunction(this.filters);
            try {
                AbstractClassificatorParser.this.addSubclass(cls, this.name, filter);
            }
            catch (IllegalArgumentException e) {
                throw new IndentParser.ParseException(e.getMessage(), this.line, this.pos);
            }
        }
    }

    class PopupOnlySS
    extends SyntaticState {
        PopupOnlySS() {
        }

        public void onPopup() throws IndentParser.ParseException {
        }
    }

    class OrCombinatorSS
    extends FilterSS {
        FilterSS parent;
        List<ClassificatorAST.Filter> filters;

        public OrCombinatorSS(FilterSS parent) {
            this.filters = new ArrayList<ClassificatorAST.Filter>();
            this.parent = parent;
        }

        @Override
        protected void push(ClassificatorAST.Filter filter) throws IndentParser.ParseException {
            this.filters.add(filter);
        }

        public void onPopup() throws IndentParser.ParseException {
            if (this.filters.isEmpty()) {
                AbstractClassificatorParser.this.error("Empty !ANY group");
                return;
            }
            this.parent.push(ClassificatorAST.conjunction(this.filters));
        }
    }

    class AndCombinatorSS
    extends FilterSS {
        FilterSS parent;
        List<ClassificatorAST.Filter> filters;

        public AndCombinatorSS(FilterSS parent) {
            this.filters = new ArrayList<ClassificatorAST.Filter>();
            this.parent = parent;
        }

        @Override
        protected void push(ClassificatorAST.Filter filter) throws IndentParser.ParseException {
            this.filters.add(filter);
        }

        public void onPopup() throws IndentParser.ParseException {
            if (this.filters.isEmpty()) {
                AbstractClassificatorParser.this.error("Empty !ALL group");
                return;
            }
            this.parent.push(ClassificatorAST.disjunction(this.filters));
        }
    }

    abstract class FilterSS
    extends SyntaticState {
        FilterSS() {
        }

        @Token(value="([^!]+)")
        public void onTokenPattern() throws IndentParser.ParseException {
            String p = AbstractClassificatorParser.this.tokenMatcher.group(1);
            ClassificatorAST.PatternFilter f = new ClassificatorAST.PatternFilter();
            f.patterns.add(p);
            AbstractClassificatorParser.this.pushState(new PopupOnlySS());
            this.push(f);
        }

        @Token(value="!(REQUIRE\\s+)?ALL")
        public void onTokenAnd() {
            AndCombinatorSS ss = new AndCombinatorSS(this);
            AbstractClassificatorParser.this.pushState(ss);
        }

        @Token(value="!(REQUIRE\\s+)?ANY")
        public void onTokenAny() {
            OrCombinatorSS ss = new OrCombinatorSS(this);
            AbstractClassificatorParser.this.pushState(ss);
        }

        @Token(value="!LAST\\s+FRAME")
        public void onTokenLastFrame() {
            LastFrameSS ss = new LastFrameSS(this);
            AbstractClassificatorParser.this.pushState(ss);
        }

        protected abstract void push(ClassificatorAST.Filter var1) throws IndentParser.ParseException;
    }

    class RootFilterSS
    extends FilterSS {
        ClassificationSS parent;

        public RootFilterSS(ClassificationSS parent) {
            this.parent = parent;
        }

        @Override
        protected void push(ClassificatorAST.Filter filter) throws IndentParser.ParseException {
            this.parent.filters.add(filter);
        }

        public void onPopup() {
        }
    }

    class ClassificationSS
    extends SyntaticState {
        RootSS root;
        AClassification classification;
        List<ClassificatorAST.Filter> filters;
        int line;
        int pos;

        public ClassificationSS(String name) {
            this.filters = new ArrayList<ClassificatorAST.Filter>();
            this.line = AbstractClassificatorParser.this.getLineNumber();
            this.pos = AbstractClassificatorParser.this.getIndent();
            this.classification = AbstractClassificatorParser.this.newClassificationNode(name);
        }

        @Token(value="\\[(.*)\\]")
        public void onTokenCategory() throws IndentParser.ParseException {
            this.onPopup();
            this.root.onTokenCategory();
        }

        @Token(value="\\+(.*)")
        public void onTokenSubclass() {
            SubclassSS ss = new SubclassSS(AbstractClassificatorParser.this.tokenMatcher.group(1), this);
            AbstractClassificatorParser.this.pushState(ss);
        }

        public void onPopup() throws IndentParser.ParseException {
            try {
                AbstractClassificatorParser.this.addToRoot(this.root.root, this.classification);
            }
            catch (IllegalArgumentException e) {
                throw new IndentParser.ParseException(e.getMessage(), this.line, this.pos);
            }
            ClassificatorAST.Filter rootFilter = ClassificatorAST.conjunction(this.filters);
            if (rootFilter != null) {
                this.classification.setRootFilter(rootFilter);
            }
        }
    }

    class RootSS
    extends SyntaticState {
        ARoot root;

        RootSS() {
            this.root = AbstractClassificatorParser.this.newRootNode();
        }

        @Token(value="\\[(.*)\\]")
        public void onTokenCategory() {
            String name = AbstractClassificatorParser.this.tokenMatcher.group(1);
            ClassificationSS cat = new ClassificationSS(name);
            cat.root = this;
            AbstractClassificatorParser.this.replaceState(cat);
            AbstractClassificatorParser.this.pushState(new RootFilterSS(cat));
        }

        public void onPopup() {
            AbstractClassificatorParser.this.result = this.root;
        }
    }

    abstract class SyntaticState {
        SyntaticState() {
        }

        public void initState() {
            for (Method m : this.getClass().getMethods()) {
                if (m.getName().startsWith("onToken")) {
                    String tn = m.getName().substring("onToken".length());
                    String pattern = m.getAnnotation(Token.class).value();
                    AbstractClassificatorParser.this.expectToken(tn, pattern);
                    continue;
                }
                if (!m.getName().startsWith("onPopup")) continue;
                AbstractClassificatorParser.this.expectPopup();
            }
        }

        public void initClassState(Class<?> c) {
            for (Method m : c.getDeclaredMethods()) {
                if (m.getName().startsWith("onToken")) {
                    String tn = m.getName().substring("onToken".length());
                    String pattern = m.getAnnotation(Token.class).value();
                    AbstractClassificatorParser.this.expectToken(tn, pattern);
                    continue;
                }
                if (!m.getName().startsWith("onPopup")) continue;
                AbstractClassificatorParser.this.expectPopup();
            }
        }

        public void popupState() throws IndentParser.ParseException {
            AbstractClassificatorParser.this.onPopup();
        }
    }
}

