/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.jfr.parser;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;

public class JfrEventAdapter
implements EventReader<Event> {
    private static final String METHOD_PROFILING_SAMPLE = "Method Profiling Sample";
    private final Iterator<IEvent> it;
    private ThreadSnapshotEventPojo eventPojo = new ThreadSnapshotEventPojo();
    private Event event = null;
    private boolean error;

    public JfrEventAdapter(FlightRecording recording) {
        this.it = recording.createView().iterator();
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    private void seek() {
        if (this.error) {
            return;
        }
        try {
            while (this.it.hasNext()) {
                IEvent e = this.it.next();
                String type = e.getEventType().getName();
                if (!METHOD_PROFILING_SAMPLE.equals(type)) continue;
                this.eventPojo.timestamp(TimeUnit.NANOSECONDS.toMillis(e.getStartTimestamp()));
                FLRThread thread = (FLRThread)e.getValue("(thread)");
                if (thread != null) {
                    this.eventPojo.threadId(thread.getThreadId());
                    this.eventPojo.threadName(thread.getThreadName());
                } else {
                    this.eventPojo.threadId(-1L);
                    this.eventPojo.threadName(null);
                }
                FLRStackTrace flrStackTrace = (FLRStackTrace)e.getValue("(stackTrace)");
                if (flrStackTrace != null) {
                    this.eventPojo.stackTrace(this.trace(flrStackTrace));
                } else {
                    this.eventPojo.stackTrace(null);
                }
                this.event = this.eventPojo;
                return;
            }
        }
        catch (Exception e) {
            this.event = new SimpleErrorEvent(e);
            this.error = true;
        }
    }

    private StackFrameList trace(FLRStackTrace trace) {
        StackFrame[] t = new StackFrame[trace.getFrames().size()];
        for (int i = 0; i != t.length; ++i) {
            t[i] = this.frame((IMCFrame)trace.getFrames().get(i));
        }
        return new StackFrameArray(t);
    }

    private StackFrame frame(IMCFrame f) {
        String src;
        int line;
        String pn = f.getMethod().getPackageName();
        String cn = f.getMethod().getClassName();
        String mn = f.getMethod().getMethodName();
        int n = line = f.getFrameLineNumber() == null ? -1 : f.getFrameLineNumber();
        if (f.getMethod().getIsNative().booleanValue()) {
            line = -2;
        }
        if ((src = f.getMethod().getFileName()) == null && line >= 0) {
            src = "line";
        }
        return new StackFrame(pn, cn, mn, src, line);
    }

    @Override
    public boolean hasNext() {
        if (this.event == null) {
            this.seek();
        }
        return this.event != null;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Event e = this.event;
        this.event = null;
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return new MorphingEventReader<M>(this, morpher);
    }

    @Override
    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.event;
    }

    @Override
    public void dispose() {
    }
}

