/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.win32;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Properties;

public class SjkWinHelper {
    int[] callBuf = new int[8];

    private static void loadNative() throws IOException {
        File tmp = File.createTempFile("java", "").getAbsoluteFile().getParentFile();
        if (tmp.getPath().startsWith("/")) {
            throw new RuntimeException("Cannot load on non Windows OS");
        }
        if ("x86".equals(ManagementFactory.getOperatingSystemMXBean().getArch())) {
            SjkWinHelper.load(tmp, "32");
        } else {
            SjkWinHelper.load(tmp, "64");
        }
    }

    private static void load(File tmp, String arch) throws IOException {
        InputStream is = SjkWinHelper.class.getClassLoader().getResourceAsStream("sjkwinh.prop");
        Properties prop = new Properties();
        prop.load(is);
        String dllName = "sjkwinh" + arch + "." + prop.getProperty("dll" + arch + ".hash") + ".dll";
        int len = Integer.valueOf(prop.getProperty("dll" + arch + ".len"));
        File tgt = new File(tmp, dllName);
        if (!tgt.isFile() || tgt.length() != (long)len) {
            tgt.delete();
            InputStream dllis = SjkWinHelper.class.getClassLoader().getResourceAsStream("sjkwinh" + arch + ".dll");
            byte[] buf = new byte[len];
            int n = dllis.read(buf);
            if (n != buf.length) {
                throw new RuntimeException("Failed extract dll, size mismatch");
            }
            FileOutputStream fos = new FileOutputStream(tgt);
            fos.write(buf);
            fos.close();
        }
        System.load(tgt.getPath());
    }

    private native int GetProcessTimes(int var1, int[] var2);

    private native int GetThreadTimes(int var1, int[] var2);

    private native long QueryProcessCycleTime(int var1);

    private native long QueryThreadCycleTime(int var1);

    private native int EnumThreads(int var1, int[] var2);

    public synchronized boolean getProcessCpuTimes(int pid, long[] result) {
        int rc = this.GetProcessTimes(pid, this.callBuf);
        if (rc == 0) {
            long ktime = 0xFFFFFFFFL & (long)this.callBuf[4] | (long)this.callBuf[5] << 32;
            long utime = 0xFFFFFFFFL & (long)this.callBuf[6] | (long)this.callBuf[7] << 32;
            result[0] = ktime / 10L;
            result[1] = utime / 10L;
            return true;
        }
        System.out.println("Error code: " + rc);
        return false;
    }

    public synchronized boolean getThreadCpuTimes(int pid, long[] result) {
        int rc = this.GetThreadTimes(pid, this.callBuf);
        if (rc == 0) {
            long ktime = 0xFFFFFFFFL & (long)this.callBuf[4] | (long)this.callBuf[5] << 32;
            long utime = 0xFFFFFFFFL & (long)this.callBuf[6] | (long)this.callBuf[7] << 32;
            result[0] = ktime / 10L;
            result[1] = utime / 10L;
            return true;
        }
        System.out.println("Error code: " + rc);
        return false;
    }

    public synchronized long getProcessCpuCycles(int pid) {
        return this.QueryProcessCycleTime(pid);
    }

    public synchronized long getThreadCpuCycles(int pid) {
        return this.QueryThreadCycleTime(pid);
    }

    public synchronized int[] enumThreads(int pid) {
        int[] buf = new int[128];
        int n = this.EnumThreads(pid, buf);
        if (n < 0) {
            throw new RuntimeException("Cannot enum threads. WinError: " + -n);
        }
        while (n > buf.length) {
            buf = new int[n + 16];
            if ((n = this.EnumThreads(pid, buf)) >= 0) continue;
            throw new RuntimeException("Cannot enum threads. WinError: " + -n);
        }
        return buf.length == n ? buf : Arrays.copyOf(buf, n);
    }

    static {
        try {
            SjkWinHelper.loadNative();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

