/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.sjk.test.console.junit4;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.sjk.test.console.StopCommandAfter;
import org.gridkit.sjk.test.console.junit4.ConsoleRule;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CliTestRule
implements TestRule {
    private final Class<?> mainClass;
    public final ConsoleRule out = ConsoleRule.out();
    public final ConsoleRule err = ConsoleRule.err();

    public CliTestRule() {
        this.mainClass = null;
    }

    public CliTestRule(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    public Statement apply(Statement base, Description description) {
        StopCommandAfter duration = (StopCommandAfter)description.getAnnotation(StopCommandAfter.class);
        if (duration != null) {
            base = new Autoshutdown(base, TimeUnit.SECONDS.toMillis(duration.value()));
        }
        base = this.out.apply(base, description);
        base = this.err.apply(base, description);
        return base;
    }

    public void exec(String ... cmd) {
        try {
            CommandLauncher cl = (CommandLauncher)this.mainClass.newInstance();
            cl.suppressSystemExit();
            StringBuilder sb = new StringBuilder();
            sb.append(this.mainClass.getSimpleName());
            for (String c : cmd) {
                sb.append(' ').append(this.escape(c));
            }
            System.out.println(sb);
            this.out.line(sb.toString());
            this.out.verify();
            Assert.assertTrue((boolean)cl.start(cmd));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void fail(String ... cmd) {
        try {
            CommandLauncher cl = (CommandLauncher)this.mainClass.newInstance();
            cl.suppressSystemExit();
            StringBuilder sb = new StringBuilder();
            sb.append(this.mainClass.getSimpleName());
            for (String c : cmd) {
                sb.append(' ').append(this.escape(c));
            }
            System.out.println(sb);
            this.out.line(sb.toString());
            this.out.verify();
            Assert.assertFalse((boolean)cl.start(cmd));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object escape(String c) {
        if (c.split("\\s").length > 1) {
            return '\"' + c + '\"';
        }
        return c;
    }

    static class Autoshutdown
    extends Statement {
        private final Statement fOriginalStatement;
        private final long fTimeout;

        public Autoshutdown(Statement originalStatement, long timeout) {
            this.fOriginalStatement = originalStatement;
            this.fTimeout = timeout;
        }

        public void evaluate() throws Throwable {
            StatementThread thread = this.evaluateStatement();
            if (!thread.fFinished) {
                this.throwExceptionForUnfinishedThread(thread);
            }
        }

        private StatementThread evaluateStatement() throws InterruptedException {
            ThreadGroup tg = new ThreadGroup("TestGroup");
            StatementThread thread = new StatementThread(tg, this.fOriginalStatement);
            thread.start();
            thread.join(this.fTimeout);
            if (thread.isAlive()) {
                System.err.println("Command interrupted - @StopCommandAfter");
                thread.silentShutdown = true;
                this.shutdown(tg);
                thread.join(1000L);
                this.shutdown(tg);
            }
            this.join(tg);
            return thread;
        }

        private void shutdown(ThreadGroup tg) {
            Thread[] threads;
            for (Thread th : threads = this.listThreads(tg)) {
                if (th == null) continue;
                th.interrupt();
            }
        }

        private void join(ThreadGroup tg) {
            Thread[] threads;
            for (Thread th : threads = this.listThreads(tg)) {
                if (th == null) continue;
                try {
                    th.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private Thread[] listThreads(ThreadGroup tg) {
            Thread[] threads = new Thread[2 * tg.activeCount()];
            int n;
            while ((n = tg.enumerate(threads, true)) != 0) {
                if (n < threads.length) {
                    return Arrays.copyOf(threads, n);
                }
                threads = new Thread[2 * threads.length];
            }
            return new Thread[0];
        }

        private void throwExceptionForUnfinishedThread(StatementThread thread) throws Throwable {
            if (thread.fExceptionThrownByOriginalStatement != null) {
                throw thread.fExceptionThrownByOriginalStatement;
            }
        }

        private static class StatementThread
        extends Thread {
            private final Statement fStatement;
            private boolean fFinished = false;
            private Throwable fExceptionThrownByOriginalStatement = null;
            private boolean silentShutdown;

            public StatementThread(ThreadGroup group, Statement statement) {
                super(group, "TestThread");
                this.fStatement = statement;
            }

            @Override
            public void run() {
                block3: {
                    try {
                        this.fStatement.evaluate();
                        this.fFinished = true;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable e) {
                        if (this.silentShutdown) break block3;
                        this.fExceptionThrownByOriginalStatement = e;
                    }
                }
            }
        }
    }
}

