/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.sjk.test.console.junit5;

import org.gridkit.sjk.test.console.ConsoleTracker;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ConsoleExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final ConsoleTracker tracker;

    public static ConsoleExtension out() {
        return new ConsoleExtension(ConsoleTracker.out());
    }

    public static ConsoleExtension err() {
        return new ConsoleExtension(ConsoleTracker.err());
    }

    ConsoleExtension(ConsoleTracker consoleTracker) {
        this.tracker = consoleTracker;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.tracker.init();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.tracker.complete();
    }

    public void verify() {
        this.tracker.verify();
    }

    public ConsoleExtension skip() {
        this.tracker.skip();
        return this;
    }

    public ConsoleExtension skip(int lines) {
        this.tracker.skip(lines);
        return this;
    }

    public ConsoleExtension line(String exact) {
        this.tracker.line(exact);
        return this;
    }

    public ConsoleExtension lineStarts(String starts) {
        this.tracker.lineStarts(starts);
        return this;
    }

    public ConsoleExtension lineStartsEx(String starts, String ... vars) {
        this.tracker.lineStartsEx(starts, vars);
        return this;
    }

    public ConsoleExtension lineContains(String ... substring) {
        this.tracker.lineContains(substring);
        return this;
    }

    public ConsoleExtension lineContainsEx(String substring, String ... vars) {
        this.tracker.lineContainsEx(substring, vars);
        return this;
    }

    public ConsoleExtension lineEx(String pattern, String ... vars) {
        this.tracker.lineEx(pattern, vars);
        return this;
    }

    public String toString() {
        return this.tracker.toString();
    }
}

