/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.HashMap;
import java.util.Map;
import org.gridkit.jvmtool.stacktrace.ThreadCounters;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class AllocAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    private Map<Long, ThreadTrack> info = new HashMap<Long, ThreadTrack>();

    AllocAggregatorFactory() {
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new AllocAggregatorFactory();
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        if (threadInfo.counters().getValue(ThreadCounters.ALLOCATED_BYTES) != Long.MIN_VALUE) {
            ThreadTrack tt = this.info.get(threadInfo.threadId());
            if (tt == null) {
                tt = new ThreadTrack();
                tt.firstTimestamp = threadInfo.timestamp();
                tt.lastTimestamp = threadInfo.timestamp();
                tt.fisrtAlloc = threadInfo.counters().getValue(ThreadCounters.ALLOCATED_BYTES);
                tt.lastAlloc = threadInfo.counters().getValue(ThreadCounters.ALLOCATED_BYTES);
                this.info.put(threadInfo.threadId(), tt);
            } else {
                if (tt.firstTimestamp > threadInfo.timestamp()) {
                    tt.firstTimestamp = threadInfo.timestamp();
                    tt.fisrtAlloc = threadInfo.counters().getValue(ThreadCounters.ALLOCATED_BYTES);
                }
                if (tt.lastTimestamp < threadInfo.timestamp()) {
                    tt.lastTimestamp = threadInfo.timestamp();
                    tt.lastAlloc = threadInfo.counters().getValue(ThreadCounters.ALLOCATED_BYTES);
                }
            }
        }
    }

    @Override
    public Object info() {
        long totalAlloc = 0L;
        long minTs = Long.MAX_VALUE;
        long maxTs = Long.MIN_VALUE;
        for (ThreadTrack tt : this.info.values()) {
            totalAlloc += tt.lastAlloc - tt.fisrtAlloc;
            minTs = Math.min(minTs, tt.firstTimestamp);
            maxTs = Math.max(maxTs, tt.lastTimestamp);
        }
        if (minTs == Long.MAX_VALUE || minTs == maxTs) {
            return Double.NaN;
        }
        return (double)totalAlloc / (double)(maxTs - minTs) * 1000.0;
    }

    private static class ThreadTrack {
        long firstTimestamp;
        long fisrtAlloc;
        long lastTimestamp;
        long lastAlloc;

        private ThreadTrack() {
        }
    }
}

