/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.RotatingStringDictionary;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class StackTraceCodec {
    static final byte[] MAGIC = StackTraceCodec.toBytes("TRACEDUMP_1 ");
    static final byte[] MAGIC2 = StackTraceCodec.toBytes("TRACEDUMP_2 ");
    static final byte TAG_STRING = 1;
    static final byte TAG_FRAME = 2;
    static final byte TAG_TRACE = 3;
    static final byte TAG_DYN_STRING = 4;
    static final byte TAG_COUNTER = 5;
    static final long TIME_ANCHOR = 1391255854894L;

    private static byte[] toBytes(String text) {
        try {
            return text.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static StackTraceWriter newWriter(OutputStream os) throws IOException {
        return new StackTraceWriterV2(os);
    }

    public static StackTraceReader newReader(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte[] magic = new byte[MAGIC.length];
        dis.readFully(magic);
        if (Arrays.equals(MAGIC, magic)) {
            return new StackTraceReaderV1(is);
        }
        if (Arrays.equals(MAGIC2, magic)) {
            return new StackTraceReaderV2(is);
        }
        throw new IOException("Unknown magic [" + new String(magic) + "]");
    }

    public static StackTraceReader newReader(String ... files) throws IOException {
        final ArrayList<String> fileList = new ArrayList<String>(Arrays.asList(files));
        return new ChainedStackTraceReader(){

            @Override
            protected StackTraceReader next() {
                while (!fileList.isEmpty()) {
                    String file = (String)fileList.remove(0);
                    File f = new File(file);
                    if (!f.isFile()) continue;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        return StackTraceCodec.newReader(fis);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    static int readVarInt(DataInputStream dis) throws IOException {
        byte b = dis.readByte();
        if ((b & 0x80) == 0) {
            return 0x7F & b;
        }
        int v = 0x7F & b;
        b = dis.readByte();
        v |= (0x7F & b) << 7;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7F & b) << 14;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        return v |= (0xFF & b) << 21;
    }

    static long readVarLong(DataInputStream dis) throws IOException {
        byte b = dis.readByte();
        if ((b & 0x80) == 0) {
            return 0x7F & b;
        }
        long v = 0x7F & b;
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 7;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 14;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 21;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 28;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 35;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 42;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 49;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        return v |= (0xFFL & (long)b) << 56;
    }

    static long readTimestamp(DataInputStream dis) throws IOException {
        return 1391255854894L + StackTraceCodec.readVarLong(dis);
    }

    static void writeVarInt(DataOutputStream dos, int v) throws IOException {
        if (v < 0) {
            throw new IllegalArgumentException("Out of bounds: " + v);
        }
        int val = v;
        if ((val & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF00) == 0) {
            dos.write(val);
            return;
        }
        throw new IllegalArgumentException("Out of bounds: " + v);
    }

    static void writeVarLong(DataOutputStream dos, long v) throws IOException {
        long val = v;
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF00L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        throw new IllegalArgumentException("Out of bounds: " + v);
    }

    static void writeTimestamp(DataOutputStream dos, long epoch) throws IOException {
        StackTraceCodec.writeVarLong(dos, epoch - 1391255854894L);
    }

    static class StackTraceReaderV2
    implements StackTraceReader {
        private DataInputStream dis;
        private List<String> stringDic = new ArrayList<String>();
        private List<StackFrame> frameDic = new ArrayList<StackFrame>();
        private Map<StackFrame, StackTraceElement> frameCache = new HashMap<StackFrame, StackTraceElement>();
        private List<String> dynStringDic = new ArrayList<String>();
        private boolean loaded;
        private long threadId;
        private String threadName;
        private long timestamp;
        private Thread.State threadState;
        private String[] counterNames = new String[0];
        private long[] counterValues = new long[0];
        private CounterArray counters = new CounterArray(this.counterNames, this.counterValues);
        private StackFrameList trace;

        public StackTraceReaderV2(InputStream is) {
            this.dis = new DataInputStream(new InflaterInputStream(is));
            this.stringDic.add(null);
            this.dynStringDic.add(null);
            this.frameDic.add(null);
            this.loaded = false;
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public long getThreadId() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            return this.threadId;
        }

        @Override
        public long getTimestamp() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            return this.timestamp;
        }

        @Override
        public StackTraceElement[] getTrace() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            StackTraceElement[] strace = new StackTraceElement[this.trace.depth()];
            for (int i = 0; i != strace.length; ++i) {
                StackFrame frame = this.trace.frameAt(i);
                StackTraceElement e = this.frameCache.get(frame);
                if (e == null) {
                    e = frame.toStackTraceElement();
                    this.frameCache.put(frame, e);
                }
                strace[i] = e;
            }
            return strace;
        }

        @Override
        public StackFrameList getStackTrace() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            return this.trace;
        }

        @Override
        public String getThreadName() {
            return this.threadName;
        }

        @Override
        public Thread.State getThreadState() {
            return this.threadState;
        }

        @Override
        public CounterCollection getCounters() {
            return this.counters;
        }

        @Override
        public boolean loadNext() throws IOException {
            block7: {
                this.loaded = false;
                while (true) {
                    int tag;
                    if ((tag = this.dis.read()) < 0) {
                        this.dis.close();
                        break block7;
                    }
                    if (tag == 1) {
                        String str = this.dis.readUTF();
                        this.stringDic.add(str);
                        continue;
                    }
                    if (tag == 2) {
                        StackFrame ste = this.readStackTraceElement();
                        this.frameDic.add(ste);
                        continue;
                    }
                    if (tag == 3) {
                        this.readTraceInfo();
                        this.loaded = true;
                        break block7;
                    }
                    if (tag == 4) {
                        int id = StackTraceCodec.readVarInt(this.dis);
                        String str = this.dis.readUTF();
                        while (this.dynStringDic.size() <= id) {
                            this.dynStringDic.add(null);
                        }
                        this.dynStringDic.set(id, str);
                        continue;
                    }
                    if (tag != 5) break;
                    String str = this.dis.readUTF();
                    int n = this.counterNames.length;
                    this.counterNames = Arrays.copyOf(this.counterNames, n + 1);
                    this.counterValues = Arrays.copyOf(this.counterValues, n + 1);
                    this.counterNames[n] = str;
                    this.counters = new CounterArray(this.counterNames, this.counterValues);
                }
                throw new IOException("Data format error");
            }
            return this.loaded;
        }

        protected void readTraceInfo() throws IOException {
            this.threadId = StackTraceCodec.readVarLong(this.dis);
            this.threadName = this.dynStringDic.get(StackTraceCodec.readVarInt(this.dis));
            this.timestamp = StackTraceCodec.readTimestamp(this.dis);
            this.threadState = this.readState();
            this.readCounters();
            this.readStackTrace();
        }

        protected Thread.State readState() throws IOException {
            int n = StackTraceCodec.readVarInt(this.dis);
            return n == 0 ? null : Thread.State.values()[n - 1];
        }

        protected void readCounters() throws IOException {
            Arrays.fill(this.counterValues, Long.MIN_VALUE);
            boolean[] mask = new boolean[this.counterNames.length];
            for (int n = 0; n < mask.length; n += 8) {
                byte b = this.dis.readByte();
                for (int i = 0; i != 8; ++i) {
                    if (n + i >= mask.length) continue;
                    mask[n + i] = (b & 1 << i) != 0;
                }
            }
            for (int i = 0; i != mask.length; ++i) {
                if (!mask[i]) continue;
                this.counterValues[i] = StackTraceCodec.readVarLong(this.dis);
            }
        }

        protected void readStackTrace() throws IOException {
            int len = StackTraceCodec.readVarInt(this.dis);
            StackFrame[] frames = new StackFrame[len];
            for (int i = 0; i != len; ++i) {
                int ref = StackTraceCodec.readVarInt(this.dis);
                frames[i] = this.frameDic.get(ref);
            }
            this.trace = new StackFrameArray(frames);
        }

        private StackFrame readStackTraceElement() throws IOException {
            int npkg = StackTraceCodec.readVarInt(this.dis);
            int ncn = StackTraceCodec.readVarInt(this.dis);
            int nmtd = StackTraceCodec.readVarInt(this.dis);
            int nfile = StackTraceCodec.readVarInt(this.dis);
            int line = StackTraceCodec.readVarInt(this.dis) - 2;
            String cp = this.stringDic.get(npkg);
            String cn = this.stringDic.get(ncn);
            String mtd = this.stringDic.get(nmtd);
            String file = this.stringDic.get(nfile);
            StackFrame e = new StackFrame(cp, cn, mtd, file, line);
            return e;
        }
    }

    static class StackTraceReaderV1
    implements StackTraceReader {
        private DataInputStream dis;
        private List<String> stringDic = new ArrayList<String>();
        private List<StackFrame> frameDic = new ArrayList<StackFrame>();
        private Map<StackFrame, StackTraceElement> frameCache = new HashMap<StackFrame, StackTraceElement>();
        private boolean loaded;
        private long threadId;
        private long timestamp;
        private StackFrameList trace;

        public StackTraceReaderV1(InputStream is) {
            this.dis = new DataInputStream(new InflaterInputStream(is));
            this.stringDic.add(null);
            this.frameDic.add(null);
            this.loaded = false;
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public long getThreadId() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            return this.threadId;
        }

        @Override
        public long getTimestamp() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            return this.timestamp;
        }

        @Override
        public StackTraceElement[] getTrace() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            StackTraceElement[] strace = new StackTraceElement[this.trace.depth()];
            for (int i = 0; i != strace.length; ++i) {
                StackFrame frame = this.trace.frameAt(i);
                StackTraceElement e = this.frameCache.get(frame);
                if (e == null) {
                    e = frame.toStackTraceElement();
                    this.frameCache.put(frame, e);
                }
                strace[i] = e;
            }
            return strace;
        }

        @Override
        public StackFrameList getStackTrace() {
            if (!this.isLoaded()) {
                throw new NoSuchElementException();
            }
            return this.trace;
        }

        @Override
        public String getThreadName() {
            return null;
        }

        @Override
        public Thread.State getThreadState() {
            return null;
        }

        @Override
        public CounterCollection getCounters() {
            return CounterArray.EMPTY;
        }

        @Override
        public boolean loadNext() throws IOException {
            block6: {
                int tag;
                this.loaded = false;
                while (true) {
                    if ((tag = this.dis.read()) < 0) {
                        this.dis.close();
                        break block6;
                    }
                    if (tag == 1) {
                        String str = this.dis.readUTF();
                        this.stringDic.add(str);
                        continue;
                    }
                    if (tag != 2) break;
                    StackFrame ste = this.readStackTraceElement();
                    this.frameDic.add(ste);
                }
                if (tag == 3) {
                    this.threadId = this.dis.readLong();
                    this.timestamp = this.dis.readLong();
                    int len = StackTraceCodec.readVarInt(this.dis);
                    StackFrame[] frames = new StackFrame[len];
                    for (int i = 0; i != len; ++i) {
                        int ref = StackTraceCodec.readVarInt(this.dis);
                        frames[i] = this.frameDic.get(ref);
                    }
                    this.trace = new StackFrameArray(frames);
                    this.loaded = true;
                } else {
                    throw new IOException("Data format error");
                }
            }
            return this.loaded;
        }

        private StackFrame readStackTraceElement() throws IOException {
            int npkg = StackTraceCodec.readVarInt(this.dis);
            int ncn = StackTraceCodec.readVarInt(this.dis);
            int nmtd = StackTraceCodec.readVarInt(this.dis);
            int nfile = StackTraceCodec.readVarInt(this.dis);
            int line = StackTraceCodec.readVarInt(this.dis) - 2;
            String cp = this.stringDic.get(npkg);
            String cn = this.stringDic.get(ncn);
            String mtd = this.stringDic.get(nmtd);
            String file = this.stringDic.get(nfile);
            StackFrame e = new StackFrame(cp, cn, mtd, file, line);
            return e;
        }
    }

    static class StackTraceWriterV2
    implements StackTraceWriter {
        private DataOutputStream dos;
        private Map<String, Integer> stringDic = new HashMap<String, Integer>();
        private Map<StackTraceElement, Integer> frameDic = new HashMap<StackTraceElement, Integer>();
        private RotatingStringDictionary dynDic = new RotatingStringDictionary(512);
        private List<String> counterKeys = new ArrayList<String>();

        public StackTraceWriterV2(OutputStream os) throws IOException {
            os.write(MAGIC2);
            DeflaterOutputStream def = new DeflaterOutputStream(os);
            this.dos = new DataOutputStream(def);
        }

        @Override
        public void write(ThreadSnapshot snap) throws IOException {
            for (StackFrame ste : snap.stackTrace()) {
                this.intern(ste.toStackTraceElement());
            }
            for (String ckey : snap.counters()) {
                this.ensureCounter(ckey);
            }
            int threadNameRef = 0;
            if (snap.threadName() != null) {
                threadNameRef = this.internDyn(snap.threadName());
            }
            this.dos.writeByte(3);
            StackTraceCodec.writeVarLong(this.dos, snap.threadId());
            StackTraceCodec.writeVarInt(this.dos, threadNameRef);
            StackTraceCodec.writeTimestamp(this.dos, snap.timestamp());
            this.writeState(snap.threadState());
            this.writeCounters(snap.counters());
            this.writeTrace(snap.stackTrace());
        }

        private void writeCounters(CounterCollection counters) throws IOException {
            long val;
            for (int n = 0; n < this.counterKeys.size(); n += 8) {
                int mask = 0;
                for (int i = 0; i < 8 && n + i < this.counterKeys.size(); ++i) {
                    val = counters.getValue(this.counterKeys.get(i));
                    if (val < 0L) continue;
                    mask = (byte)(mask | 1 << i);
                }
                this.dos.writeByte(mask);
            }
            for (String key : this.counterKeys) {
                val = counters.getValue(key);
                if (val < 0L) continue;
                StackTraceCodec.writeVarLong(this.dos, val);
            }
        }

        private void writeState(Thread.State state) throws IOException {
            StackTraceCodec.writeVarInt(this.dos, state == null ? 0 : state.ordinal() + 1);
        }

        private void writeTrace(StackFrameList trace) throws IOException {
            int n = 0;
            for (StackFrame sf : trace) {
                ++n;
            }
            StackTraceCodec.writeVarInt(this.dos, n);
            for (StackFrame ste : trace) {
                StackTraceCodec.writeVarInt(this.dos, this.intern(ste.toStackTraceElement()));
            }
        }

        private int intern(StackTraceElement ste) throws IOException {
            if (!this.frameDic.containsKey(ste)) {
                String pkg = ste.getClassName();
                int c = pkg.lastIndexOf(46);
                String cn = c < 0 ? pkg : pkg.substring(c + 1);
                pkg = c < 0 ? null : pkg.substring(0, c);
                String mtd = ste.getMethodName();
                String file = ste.getFileName();
                int line = ste.getLineNumber() + 2;
                if (line < 0) {
                    line = 0;
                }
                int npkg = this.intern(pkg);
                int ncn = this.intern(cn);
                int nmtd = this.intern(mtd);
                int nfile = this.intern(file);
                this.dos.writeByte(2);
                StackTraceCodec.writeVarInt(this.dos, npkg);
                StackTraceCodec.writeVarInt(this.dos, ncn);
                StackTraceCodec.writeVarInt(this.dos, nmtd);
                StackTraceCodec.writeVarInt(this.dos, nfile);
                StackTraceCodec.writeVarInt(this.dos, line);
                int n = this.frameDic.size() + 1;
                this.frameDic.put(ste, n);
            }
            return this.frameDic.get(ste);
        }

        private int intern(String str) throws IOException {
            if (str == null) {
                return 0;
            }
            if (!this.stringDic.containsKey(str)) {
                this.dos.write(1);
                this.dos.writeUTF(str);
                int n = this.stringDic.size() + 1;
                this.stringDic.put(str, n);
            }
            return this.stringDic.get(str);
        }

        private int internDyn(String str) throws IOException {
            if (str == null) {
                return 0;
            }
            int n = this.dynDic.intern(str);
            if (n < 0) {
                this.dos.write(4);
                StackTraceCodec.writeVarInt(this.dos, (n ^= 0xFFFFFFFF) + 1);
                this.dos.writeUTF(str);
            }
            return ++n;
        }

        private void ensureCounter(String key) throws IOException {
            int n = this.counterKeys.indexOf(key);
            if (n < 0) {
                n = this.counterKeys.size();
                this.counterKeys.add(key);
                this.dos.write(5);
                this.dos.writeUTF(key);
            }
        }

        @Override
        public void close() {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stringDic.clear();
            this.frameDic.clear();
        }
    }

    static abstract class ChainedStackTraceReader
    implements StackTraceReader {
        private StackTraceReader current;

        ChainedStackTraceReader() {
        }

        protected abstract StackTraceReader next();

        @Override
        public boolean isLoaded() {
            if (this.current == null) {
                this.current = this.next();
            }
            return this.current != null && this.current.isLoaded();
        }

        @Override
        public long getThreadId() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getThreadId();
        }

        @Override
        public String getThreadName() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getThreadName();
        }

        @Override
        public long getTimestamp() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getTimestamp();
        }

        @Override
        public Thread.State getThreadState() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getThreadState();
        }

        @Override
        public CounterCollection getCounters() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getCounters();
        }

        @Override
        public StackTraceElement[] getTrace() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getTrace();
        }

        @Override
        public StackFrameList getStackTrace() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getStackTrace();
        }

        @Override
        public boolean loadNext() throws IOException {
            if (this.current == null) {
                this.current = this.next();
                if (this.current == null) {
                    return false;
                }
            }
            if (this.current.loadNext()) {
                return true;
            }
            this.current = null;
            return this.loadNext();
        }
    }
}

