/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.AbstractEventDumpSource;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.event.ErrorHandler;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.ShieldedEventReader;
import org.gridkit.jvmtool.stacktrace.analytics.CachingFilterFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ParserException;
import org.gridkit.jvmtool.stacktrace.analytics.PositionalStackMatcher;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadEventFilter;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.jvmtool.stacktrace.analytics.TimeRangeChecker;
import org.gridkit.jvmtool.stacktrace.analytics.TraceFilterPredicateParser;

public abstract class AbstractThreadDumpSource
extends AbstractEventDumpSource {
    @Parameter(names={"-tf", "--trace-filter"}, required=false, description="Apply filter to traces before processing. Use --ssa-help for more details about filter notation")
    private String traceFilter = null;
    @Parameter(names={"-tt", "--trace-trim"}, required=false, description="Positional filter trim frames to process. Use --ssa-help for more details about filter notation")
    private String traceTrim = null;
    @Parameter(names={"-tn", "--thread-name"}, required=false, description="Thread name filter (Java RegEx syntax)")
    private String threadName = null;

    public AbstractThreadDumpSource(CommandLauncher host) {
        super(host);
    }

    public EventReader<ThreadSnapshotEvent> getFilteredReader() {
        if (this.traceFilter == null && this.traceTrim == null && this.threadName == null && this.timeRange == null) {
            return this.getUnclassifiedReader();
        }
        EventReader<ThreadSnapshotEvent> reader = this.getUnclassifiedReader();
        if (this.threadName != null) {
            reader = reader.morph(new ThreadNameFilter(this.threadName));
        }
        if (this.timeRange != null) {
            String[] lh = this.timeRange.split("[-]");
            if (lh.length != 2) {
                this.host.fail("Invalid time range '" + this.timeRange + "'", "Valid format yyyy.MM.dd_HH:mm:ss-yyyy.MM.dd_HH:mm:ss hours and higher parts can be ommited");
            }
            TimeRangeChecker checker = new TimeRangeChecker(lh[0], lh[1], this.timeZone);
            reader = reader.morph(new TimeFilter(checker));
        }
        try {
            CachingFilterFactory factory = new CachingFilterFactory();
            if (this.traceFilter != null) {
                ThreadSnapshotFilter ts = TraceFilterPredicateParser.parseFilter(this.traceFilter, factory);
                reader = reader.morph(new ThreadEventFilter(ts));
            }
            if (this.traceTrim != null) {
                final PositionalStackMatcher mt = TraceFilterPredicateParser.parsePositionMatcher(this.traceTrim, factory);
                reader = reader.morph(new TrimProxy(){

                    @Override
                    public ThreadSnapshotEvent morph(ThreadSnapshotEvent event) {
                        int n = mt.matchNext(event, 0);
                        if (n >= 0) {
                            this.trimPoint = n;
                            return super.morph(event);
                        }
                        return null;
                    }
                });
            }
            return reader;
        }
        catch (ParserException e) {
            throw this.host.fail("Failed to parse trace filter - " + e.getMessage() + " at " + e.getOffset() + " [" + e.getParseText() + "]");
        }
    }

    @Override
    protected abstract List<String> inputFiles();

    public EventReader<ThreadSnapshotEvent> getUnclassifiedReader() {
        EventReader<Event> rawReader = this.getRawReader();
        ShieldedEventReader<ThreadSnapshotEvent> shielderReader = new ShieldedEventReader<ThreadSnapshotEvent>(rawReader, ThreadSnapshotEvent.class, new ErrorHandler(){

            @Override
            public boolean onException(Exception e) {
                System.err.println("Stream reader error: " + e);
                return true;
            }
        });
        return shielderReader;
    }

    static class TrimProxy
    implements EventMorpher<ThreadSnapshotEvent, ThreadSnapshotEvent> {
        protected ThreadSnapshotEventPojo snap = new ThreadSnapshotEventPojo();
        protected int trimPoint = 0;

        @Override
        public ThreadSnapshotEvent morph(ThreadSnapshotEvent event) {
            this.snap.loadFrom(event);
            this.snap.stackTrace(event.stackTrace().fragment(0, this.trimPoint));
            return this.snap;
        }
    }

    static class ThreadNameFilter
    implements EventMorpher<ThreadSnapshotEvent, ThreadSnapshotEvent> {
        Matcher matcher;

        public ThreadNameFilter(String regex) {
            this.matcher = Pattern.compile(regex).matcher("");
        }

        @Override
        public ThreadSnapshotEvent morph(ThreadSnapshotEvent event) {
            return this.evaluate(event) ? event : null;
        }

        protected boolean evaluate(ThreadSnapshotEvent event) {
            if (event.threadName() != null) {
                this.matcher.reset(event.threadName());
                return this.matcher.matches();
            }
            return false;
        }
    }

    static class TimeFilter
    implements EventMorpher<ThreadSnapshotEvent, ThreadSnapshotEvent> {
        TimeRangeChecker checker;

        public TimeFilter(TimeRangeChecker checker) {
            this.checker = checker;
        }

        @Override
        public ThreadSnapshotEvent morph(ThreadSnapshotEvent event) {
            return this.checker.evaluate(event.timestamp()) ? event : null;
        }
    }
}

