/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.parser;

import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.unit.ContentType;

public final class ValueField {
    private final String identifier;
    private final String name;
    private final String description;
    private final ContentType<?> contentType;

    public ValueField(IAttribute<?> attribute) {
        this(attribute.getIdentifier(), attribute.getName(), attribute.getDescription(), attribute.getContentType());
    }

    public ValueField(String identifier, String name, String description, ContentType<?> contentType) {
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.contentType = contentType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ContentType<?> getContentType() {
        return this.contentType;
    }

    public boolean matches(IAttribute<?> a) {
        return this.identifier.equals(a.getIdentifier()) && this.contentType.equals(a.getContentType());
    }

    public String toString() {
        return this.identifier + ":" + this.contentType;
    }
}

