/*
 * Decompiled with CFR 0.152.
 */
package org.perfkit.sjk.jfr.mcparser;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gridkit.jvmtool.util.json.JsonStreamWriter;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.TimestampUnit;

public class JsonEventAdapter {
    private final int maxDepth;
    private Set<String> whiteList;
    private Set<String> blackList;

    public JsonEventAdapter() {
        this(Integer.MAX_VALUE);
    }

    public JsonEventAdapter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setWhiteList(Collection<String> events) {
        this.whiteList = new HashSet<String>(events);
    }

    public void setBlackList(Collection<String> events) {
        this.blackList = new HashSet<String>(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeEvent(IItem event, JsonStreamWriter writer) throws IOException {
        writer.writeStartObject();
        try {
            String eventType = event.getType().getIdentifier();
            if (this.shouldOutput(eventType)) {
                writer.writeStringField("eventType", event.getType().getIdentifier());
                this.encodeObject(event, writer, 1);
            }
        }
        finally {
            writer.writeEndObject();
        }
    }

    private boolean shouldOutput(String eventType) {
        if (this.whiteList != null && !this.whiteList.contains(eventType)) {
            return false;
        }
        return this.blackList == null || !this.blackList.contains(eventType);
    }

    private boolean checkDepthLimit(JsonStreamWriter writer, int depth) throws IOException {
        if (depth > this.maxDepth) {
            writer.writeStringField("json_depth_limit_reached", "!");
            return false;
        }
        return true;
    }

    private void encodeObject(IItem obj, JsonStreamWriter writer, int depth) throws IOException {
        if (!this.checkDepthLimit(writer, depth)) {
            return;
        }
        ITypedQuantity startTime = null;
        for (IAccessorKey<?> k : obj.getType().getAccessorKeys().keySet()) {
            String name = k.getIdentifier();
            if (!(k instanceof Attribute)) continue;
            Attribute a = (Attribute)k;
            Object val = a.getAccessor(obj.getType()).getMember(this.cast(obj));
            if ("startTime".equals(name)) {
                startTime = (ITypedQuantity)val;
            } else if ("(endTime)".equals(name)) {
                if (startTime == null) {
                    name = "startTime";
                } else {
                    name = "duration";
                    val = ((Number)val).longValue() - ((Number)((Object)startTime)).longValue();
                }
            }
            writer.writeFieldName(name);
            this.encodeValue(val, writer, depth);
        }
    }

    private void encodeFieldValue(String field, Object val, JsonStreamWriter writer, int depth) throws IOException {
        writer.writeFieldName(field);
        this.encodeValue(val, writer, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void encodeValue(Object val, JsonStreamWriter writer, int depth) throws IOException {
        if (val == null) {
            writer.writeNull();
            return;
        } else if (val instanceof TimestampUnit) {
            writer.writeString(val.toString());
            return;
        } else if (val instanceof Number) {
            Number num = (Number)val;
            if ((double)num.longValue() == num.doubleValue()) {
                writer.writeNumber(num.longValue());
                return;
            } else {
                writer.writeNumber(num.doubleValue());
            }
            return;
        } else if (val instanceof IMCThread) {
            IMCThread thread = (IMCThread)val;
            writer.writeStartObject();
            try {
                if (!this.checkDepthLimit(writer, depth)) return;
                writer.writeNumberField("osThreadId", thread.hashCode());
                writer.writeStringField("javaName", thread.getThreadName());
                this.encodeFieldValue("javaThreadId", thread.getThreadId(), writer, depth + 1);
                this.encodeFieldValue("group", thread.getThreadGroup(), writer, depth + 1);
                return;
            }
            finally {
                writer.writeEndObject();
            }
        } else if (val instanceof IMCThreadGroup) {
            IMCThreadGroup tg = (IMCThreadGroup)val;
            writer.writeStartObject();
            try {
                if (!this.checkDepthLimit(writer, depth)) return;
                this.encodeFieldValue("parent", tg.getParent(), writer, depth + 1);
                writer.writeStringField("name", tg.getName());
                return;
            }
            finally {
                writer.writeEndObject();
            }
        } else if (val instanceof IMCStackTrace) {
            IMCStackTrace trace = (IMCStackTrace)val;
            writer.writeStartObject();
            try {
                if (!this.checkDepthLimit(writer, depth)) return;
                writer.writeBooleanField("truncated", trace.getTruncationState().isTruncated());
                writer.writeFieldName("frames");
                writer.writeStartArray();
                try {
                    for (IMCFrame iMCFrame : trace.getFrames()) {
                        this.encodeValue(iMCFrame, writer, depth + 2);
                    }
                    return;
                }
                finally {
                    writer.writeEndArray();
                }
            }
            finally {
                writer.writeEndObject();
            }
        } else if (val instanceof IMCFrame) {
            IMCFrame frame = (IMCFrame)val;
            writer.writeStartObject();
            try {
                if (!this.checkDepthLimit(writer, depth)) return;
                this.encodeFieldValue("method", frame.getMethod(), writer, depth + 1);
                this.encodeFieldValue("lineNumber", frame.getFrameLineNumber(), writer, depth + 1);
                this.encodeFieldValue("bytecodeIndex", frame.getBCI(), writer, depth + 1);
                this.encodeFieldValue("type", this.frameType(frame.getType()), writer, depth + 1);
                return;
            }
            finally {
                writer.writeEndObject();
            }
        } else if (val instanceof IMCMethod) {
            IMCMethod method = (IMCMethod)val;
            writer.writeStartObject();
            try {
                writer.writeStringField("class", method.getType().getFullName());
                writer.writeStringField("method", method.getMethodName());
                return;
            }
            finally {
                writer.writeEndObject();
            }
        } else if (val instanceof IMCType) {
            IMCType type = (IMCType)val;
            writer.writeStartObject();
            try {
                writer.writeStringField("className", type.getFullName());
                return;
            }
            finally {
                writer.writeEndObject();
            }
        } else if (val instanceof Boolean) {
            writer.writeBoolean(Boolean.TRUE.equals(val));
            return;
        } else if (val instanceof String) {
            writer.writeString(val.toString());
            return;
        } else {
            writer.writeString(val.toString());
        }
    }

    private String frameType(IMCFrame.Type type) {
        switch (type) {
            case JIT_COMPILED: {
                return "JIT compiled";
            }
            case INLINED: {
                return "Inlined";
            }
            case INTERPRETED: {
                return "Interpreted";
            }
        }
        return "Native";
    }

    private <T> T cast(Object o) {
        return (T)o;
    }
}

