/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;

public class JmxConnectionInfo {
    private CommandLauncher commandHost;
    @Parameter(names={"-p", "--pid"}, description="JVM process PID")
    private Long pid;
    @Parameter(names={"-s", "--socket"}, description="Socket address for JMX port (host:port)")
    private String sockAddr;
    @Parameter(names={"--user"}, description="User for JMX authentication (only for socket connection)")
    private String user = null;
    @Parameter(names={"--password"}, description="Password for JMX authentication (only for socket connection)")
    private String password = null;
    private boolean diagMode = false;

    public JmxConnectionInfo(CommandLauncher host) {
        this.commandHost = host;
    }

    public void setDiagMode(boolean diagMode) {
        this.diagMode = diagMode;
    }

    public Long getPID() {
        return this.pid;
    }

    private String formatFailedMsg(Object vm) {
        return "Failed to access MBean server: " + String.valueOf(this.pid) + "\nFor information about troubleshooting visit\nhttps://github.com/aragozin/jvm-tools/blob/master/sjk-core/docs/TROUBLESHOOTING.md";
    }

    public MBeanServerConnection getMServer() {
        if (this.pid == null && this.sockAddr == null) {
            this.commandHost.failAndPrintUsage("JVM process is not specified");
        }
        if (this.pid != null && this.sockAddr != null) {
            this.commandHost.failAndPrintUsage("You can specify eigther PID or JMX socket connection");
        }
        if (this.pid != null) {
            MBeanServerConnection mserver;
            if (this.diagMode) {
                System.out.println("Attaching to process " + this.pid);
            }
            JavaProcessDetails jpd = AttachManager.getDetails(this.pid);
            if (this.diagMode) {
                try {
                    jpd.getVmFlag("MaxHeapSize");
                }
                catch (Exception e) {
                    this.commandHost.fail("Failed to send command via JVM attach channel", e);
                }
            }
            if ((mserver = jpd.getMBeans()) == null) {
                if (this.diagMode) {
                    try {
                        String uri = (String)jpd.getAgentProperties().get("com.sun.management.jmxremote.localConnectorAddress");
                        if (uri == null || uri.trim().length() == 0) {
                            System.out.println("Failed to start local MBean server on remote VM");
                        } else {
                            System.out.println("Local MBean server URI: " + uri);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Faield to read agent properties on remote VM");
                        e.printStackTrace(System.out);
                    }
                }
                this.commandHost.fail(this.formatFailedMsg(this.pid));
            }
            return mserver;
        }
        if (this.sockAddr != null) {
            MBeanServerConnection mserver;
            String host = this.host(this.sockAddr);
            int port = this.port(this.sockAddr);
            Map<String, String[]> env = null;
            if (this.user != null || this.password != null) {
                if (this.user == null || this.password == null) {
                    this.commandHost.failAndPrintUsage("Both user and password required for authentication");
                }
                env = Collections.singletonMap("jmx.remote.credentials", new String[]{this.user, this.password});
            }
            if ((mserver = this.connectJmx(host, port, env)) == null) {
                this.commandHost.fail(this.formatFailedMsg(host + ":" + port));
            }
            return mserver;
        }
        throw new UnsupportedOperationException();
    }

    private MBeanServerConnection connectJmx(String host, int port, Map<String, Object> props) {
        try {
            String uri;
            RMIServer rmiServer;
            block12: {
                rmiServer = null;
                try {
                    System.out.println("Try to connect via TLS");
                    Registry registry = LocateRegistry.getRegistry(host, port, new SslRMIClientSocketFactory());
                    try {
                        rmiServer = (RMIServer)registry.lookup("jmxrmi");
                    }
                    catch (NotBoundException nbe) {
                        throw (IOException)new IOException(nbe.getMessage()).initCause(nbe);
                    }
                }
                catch (IOException e) {
                    if (this.diagMode) {
                        System.out.println("Failed to connect using TLS: " + e.toString());
                        System.out.println("Try to use plain socket");
                    }
                    Registry registry = LocateRegistry.getRegistry(host, port);
                    try {
                        rmiServer = (RMIServer)registry.lookup("jmxrmi");
                    }
                    catch (NotBoundException nbe) {
                        if (!this.diagMode) break block12;
                        System.out.println("Failed using LocateRegistry. Fallback to JMXConnectorFactory");
                    }
                }
            }
            if (rmiServer != null) {
                RMIConnector rmiConnector = new RMIConnector(rmiServer, props);
                rmiConnector.connect();
                return rmiConnector.getMBeanServerConnection();
            }
            String proto = System.getProperty("jmx.service.protocol", "rmi");
            String string = uri = "rmi".equals(proto) ? "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi" : "service:jmx:" + proto + "://" + host + ":" + port;
            if (this.diagMode) {
                System.out.println("Using JMX URI: " + uri);
            }
            JMXServiceURL jmxurl = new JMXServiceURL(uri);
            JMXConnector conn = props == null ? JMXConnectorFactory.connect(jmxurl) : JMXConnectorFactory.connect(jmxurl, props);
            MBeanServerConnection mserver = conn.getMBeanServerConnection();
            return mserver;
        }
        catch (MalformedURLException e) {
            this.commandHost.fail("JMX Connection failed: " + e.toString(), e);
        }
        catch (IOException e) {
            this.commandHost.fail("JMX Connection failed: " + e.toString(), e);
        }
        return null;
    }

    private String host(String sockAddr) {
        int c = sockAddr.indexOf(58);
        if (c <= 0) {
            this.commandHost.fail("Invalid socket address: " + sockAddr);
        }
        return sockAddr.substring(0, c);
    }

    private int port(String sockAddr) {
        int c = sockAddr.indexOf(58);
        if (c <= 0) {
            this.commandHost.fail("Invalid socket address: " + sockAddr);
        }
        try {
            return Integer.valueOf(sockAddr.substring(c + 1));
        }
        catch (NumberFormatException e) {
            this.commandHost.fail("Invalid socket address: " + sockAddr);
            return 0;
        }
    }
}

