/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcflow;

public class FormatHelper {
    public static String toMemoryUnits(double value) {
        if (value == 0.0) {
            return "0";
        }
        if (value < 10240.0) {
            String val = String.format("%.2f", value).trim();
            if (val.endsWith(".00")) {
                val = val.substring(0, val.length() - 3);
            } else if (val.indexOf(46) > 0 && val.endsWith("0")) {
                val = val.substring(0, val.length() - 1);
            }
            return val;
        }
        if (value < 1048576.0) {
            return String.format("%5.4gKi", value / 1024.0).trim();
        }
        if (value < 1.073741824E9) {
            return String.format("%5.4gMi", value / 1048576.0).trim();
        }
        if (value < 1.099511627776E12) {
            return String.format("%5.4gGi", value / 1.073741824E9).trim();
        }
        return String.format("%dGi", (long)(value / 1.073741824E9)).trim();
    }

    public static String toSeconds(double value) {
        return String.format("%6.3fB", value);
    }
}

