/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.internal;

import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.SqlUtils;

public class TableStatements {
    private final Database db;
    private final String tablename;
    private final String[] allColumns;
    private final String[] pkColumns;
    private DatabaseStatement insertStatement;
    private DatabaseStatement insertOrReplaceStatement;
    private DatabaseStatement updateStatement;
    private DatabaseStatement deleteStatement;
    private DatabaseStatement countStatement;
    private volatile String selectAll;
    private volatile String selectByKey;
    private volatile String selectByRowId;
    private volatile String selectKeys;

    public TableStatements(Database db, String tablename, String[] allColumns, String[] pkColumns) {
        this.db = db;
        this.tablename = tablename;
        this.allColumns = allColumns;
        this.pkColumns = pkColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatement getInsertStatement() {
        if (this.insertStatement == null) {
            String sql = SqlUtils.createSqlInsert("INSERT INTO ", this.tablename, this.allColumns);
            DatabaseStatement newInsertStatement = this.db.compileStatement(sql);
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.insertStatement == null) {
                    this.insertStatement = newInsertStatement;
                }
            }
            if (this.insertStatement != newInsertStatement) {
                newInsertStatement.close();
            }
        }
        return this.insertStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatement getInsertOrReplaceStatement() {
        if (this.insertOrReplaceStatement == null) {
            String sql = SqlUtils.createSqlInsert("INSERT OR REPLACE INTO ", this.tablename, this.allColumns);
            DatabaseStatement newInsertOrReplaceStatement = this.db.compileStatement(sql);
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.insertOrReplaceStatement == null) {
                    this.insertOrReplaceStatement = newInsertOrReplaceStatement;
                }
            }
            if (this.insertOrReplaceStatement != newInsertOrReplaceStatement) {
                newInsertOrReplaceStatement.close();
            }
        }
        return this.insertOrReplaceStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatement getDeleteStatement() {
        if (this.deleteStatement == null) {
            String sql = SqlUtils.createSqlDelete(this.tablename, this.pkColumns);
            DatabaseStatement newDeleteStatement = this.db.compileStatement(sql);
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.deleteStatement == null) {
                    this.deleteStatement = newDeleteStatement;
                }
            }
            if (this.deleteStatement != newDeleteStatement) {
                newDeleteStatement.close();
            }
        }
        return this.deleteStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatement getUpdateStatement() {
        if (this.updateStatement == null) {
            String sql = SqlUtils.createSqlUpdate(this.tablename, this.allColumns, this.pkColumns);
            DatabaseStatement newUpdateStatement = this.db.compileStatement(sql);
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.updateStatement == null) {
                    this.updateStatement = newUpdateStatement;
                }
            }
            if (this.updateStatement != newUpdateStatement) {
                newUpdateStatement.close();
            }
        }
        return this.updateStatement;
    }

    public DatabaseStatement getCountStatement() {
        if (this.countStatement == null) {
            String sql = SqlUtils.createSqlCount(this.tablename);
            this.countStatement = this.db.compileStatement(sql);
        }
        return this.countStatement;
    }

    public String getSelectAll() {
        if (this.selectAll == null) {
            this.selectAll = SqlUtils.createSqlSelect(this.tablename, "T", this.allColumns, false);
        }
        return this.selectAll;
    }

    public String getSelectKeys() {
        if (this.selectKeys == null) {
            this.selectKeys = SqlUtils.createSqlSelect(this.tablename, "T", this.pkColumns, false);
        }
        return this.selectKeys;
    }

    public String getSelectByKey() {
        if (this.selectByKey == null) {
            StringBuilder builder = new StringBuilder(this.getSelectAll());
            builder.append("WHERE ");
            SqlUtils.appendColumnsEqValue(builder, "T", this.pkColumns);
            this.selectByKey = builder.toString();
        }
        return this.selectByKey;
    }

    public String getSelectByRowId() {
        if (this.selectByRowId == null) {
            this.selectByRowId = this.getSelectAll() + "WHERE ROWID=?";
        }
        return this.selectByRowId;
    }
}

