/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.internal;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;

public final class FastCursor
implements Cursor {
    private final CursorWindow window;
    private int position;
    private final int count;

    public FastCursor(CursorWindow window) {
        this.window = window;
        this.count = window.getNumRows();
    }

    public int getCount() {
        return this.window.getNumRows();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean move(int offset) {
        return this.moveToPosition(this.position + offset);
    }

    public boolean moveToPosition(int position) {
        if (position >= 0 && position < this.count) {
            this.position = position;
            return true;
        }
        return false;
    }

    public boolean moveToFirst() {
        this.position = 0;
        return this.count > 0;
    }

    public boolean moveToLast() {
        if (this.count > 0) {
            this.position = this.count - 1;
            return true;
        }
        return false;
    }

    public boolean moveToNext() {
        if (this.position < this.count - 1) {
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean moveToPrevious() {
        if (this.position > 0) {
            --this.position;
            return true;
        }
        return false;
    }

    public boolean isFirst() {
        return this.position == 0;
    }

    public boolean isLast() {
        return this.position == this.count - 1;
    }

    public boolean isBeforeFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() {
        throw new UnsupportedOperationException();
    }

    public int getColumnIndex(String columnName) {
        throw new UnsupportedOperationException();
    }

    public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String getColumnName(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public String[] getColumnNames() {
        throw new UnsupportedOperationException();
    }

    public int getColumnCount() {
        throw new UnsupportedOperationException();
    }

    public byte[] getBlob(int columnIndex) {
        return this.window.getBlob(this.position, columnIndex);
    }

    public String getString(int columnIndex) {
        return this.window.getString(this.position, columnIndex);
    }

    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public short getShort(int columnIndex) {
        return this.window.getShort(this.position, columnIndex);
    }

    public int getInt(int columnIndex) {
        return this.window.getInt(this.position, columnIndex);
    }

    public long getLong(int columnIndex) {
        return this.window.getLong(this.position, columnIndex);
    }

    public float getFloat(int columnIndex) {
        return this.window.getFloat(this.position, columnIndex);
    }

    public double getDouble(int columnIndex) {
        return this.window.getDouble(this.position, columnIndex);
    }

    public boolean isNull(int columnIndex) {
        return this.window.isNull(this.position, columnIndex);
    }

    public void deactivate() {
        throw new UnsupportedOperationException();
    }

    public boolean requery() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException();
    }

    public void registerContentObserver(ContentObserver observer) {
        throw new UnsupportedOperationException();
    }

    public void unregisterContentObserver(ContentObserver observer) {
        throw new UnsupportedOperationException();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        throw new UnsupportedOperationException();
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        throw new UnsupportedOperationException();
    }

    public void setNotificationUri(ContentResolver cr, Uri uri) {
        throw new UnsupportedOperationException();
    }

    public boolean getWantsAllOnMoveCalls() {
        throw new UnsupportedOperationException();
    }

    public Bundle getExtras() {
        throw new UnsupportedOperationException();
    }

    public Bundle respond(Bundle extras) {
        throw new UnsupportedOperationException();
    }

    public int getType(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public Uri getNotificationUri() {
        return null;
    }
}

