/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.query;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.query.WhereCondition;

class WhereCollector<T> {
    private final AbstractDao<T, ?> dao;
    private final List<WhereCondition> whereConditions;
    private final String tablePrefix;

    WhereCollector(AbstractDao<T, ?> dao, String tablePrefix) {
        this.dao = dao;
        this.tablePrefix = tablePrefix;
        this.whereConditions = new ArrayList<WhereCondition>();
    }

    void add(WhereCondition cond, WhereCondition ... condMore) {
        this.checkCondition(cond);
        this.whereConditions.add(cond);
        for (WhereCondition whereCondition : condMore) {
            this.checkCondition(whereCondition);
            this.whereConditions.add(whereCondition);
        }
    }

    WhereCondition combineWhereConditions(String combineOp, WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        StringBuilder builder = new StringBuilder("(");
        ArrayList<Object> combinedValues = new ArrayList<Object>();
        this.addCondition(builder, combinedValues, cond1);
        builder.append(combineOp);
        this.addCondition(builder, combinedValues, cond2);
        for (WhereCondition cond : condMore) {
            builder.append(combineOp);
            this.addCondition(builder, combinedValues, cond);
        }
        builder.append(')');
        return new WhereCondition.StringCondition(builder.toString(), combinedValues.toArray());
    }

    void addCondition(StringBuilder builder, List<Object> values, WhereCondition condition) {
        this.checkCondition(condition);
        condition.appendTo(builder, this.tablePrefix);
        condition.appendValuesTo(values);
    }

    void checkCondition(WhereCondition whereCondition) {
        if (whereCondition instanceof WhereCondition.PropertyCondition) {
            this.checkProperty(((WhereCondition.PropertyCondition)whereCondition).property);
        }
    }

    void checkProperty(Property property) {
        if (this.dao != null) {
            Property[] properties = this.dao.getProperties();
            boolean found = false;
            for (Property property2 : properties) {
                if (property != property2) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new DaoException("Property '" + property.name + "' is not part of " + this.dao);
            }
        }
    }

    void appendWhereClause(StringBuilder builder, String tablePrefixOrNull, List<Object> values) {
        ListIterator<WhereCondition> iter = this.whereConditions.listIterator();
        while (iter.hasNext()) {
            if (iter.hasPrevious()) {
                builder.append(" AND ");
            }
            WhereCondition condition = iter.next();
            condition.appendTo(builder, tablePrefixOrNull);
            condition.appendValuesTo(values);
        }
    }

    boolean isEmpty() {
        return this.whereConditions.isEmpty();
    }
}

