/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.query;

import android.database.sqlite.SQLiteDatabase;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.query.AbstractQuery;
import org.greenrobot.greendao.query.AbstractQueryData;

public class DeleteQuery<T>
extends AbstractQuery<T> {
    private final QueryData<T> queryData;

    static <T2> DeleteQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        QueryData queryData = new QueryData(dao, sql, DeleteQuery.toStringArray(initialValues));
        return (DeleteQuery)queryData.forCurrentThread();
    }

    private DeleteQuery(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, sql, initialValues);
        this.queryData = queryData;
    }

    public DeleteQuery<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    public void executeDeleteWithoutDetachingEntities() {
        this.checkThread();
        SQLiteDatabase db = this.dao.getDatabase();
        if (db.isDbLockedByCurrentThread()) {
            this.dao.getDatabase().execSQL(this.sql, (Object[])this.parameters);
        } else {
            db.beginTransaction();
            try {
                this.dao.getDatabase().execSQL(this.sql, (Object[])this.parameters);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, DeleteQuery<T2>> {
        private QueryData(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            super(dao, sql, initialValues);
        }

        @Override
        protected DeleteQuery<T2> createQuery() {
            return new DeleteQuery(this, this.dao, this.sql, (String[])this.initialValues.clone());
        }
    }
}

