/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.internal;

import de.greenrobot.dao.DaoLog;
import java.util.Arrays;

public final class LongHashMap<T> {
    private Entry<T>[] table;
    private int capacity;
    private int threshold;
    private int size;

    public LongHashMap() {
        this(16);
    }

    public LongHashMap(int capacity) {
        this.capacity = capacity;
        this.threshold = capacity * 4 / 3;
        this.table = new Entry[capacity];
    }

    public boolean containsKey(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T get(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public T put(long key, T value) {
        Entry<T> entryOriginal;
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> entry = entryOriginal = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                Object oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
            entry = entry.next;
        }
        this.table[index] = new Entry<T>(key, value, entryOriginal);
        ++this.size;
        if (this.size > this.threshold) {
            this.setCapacity(2 * this.capacity);
        }
        return null;
    }

    public T remove(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> previous = null;
        Entry<T> entry = this.table[index];
        while (entry != null) {
            Entry next = entry.next;
            if (entry.key == key) {
                if (previous == null) {
                    this.table[index] = next;
                } else {
                    previous.next = next;
                }
                --this.size;
                return entry.value;
            }
            previous = entry;
            entry = next;
        }
        return null;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    public int size() {
        return this.size;
    }

    public void setCapacity(int newCapacity) {
        Entry[] newTable = new Entry[newCapacity];
        for (Entry<T> entry : this.table) {
            while (entry != null) {
                long key = entry.key;
                int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % newCapacity;
                Entry originalNext = entry.next;
                entry.next = newTable[index];
                newTable[index] = entry;
                entry = originalNext;
            }
        }
        this.table = newTable;
        this.capacity = newCapacity;
        this.threshold = newCapacity * 4 / 3;
    }

    public void reserveRoom(int entryCount) {
        this.setCapacity(entryCount * 5 / 3);
    }

    public void logStats() {
        int collisions = 0;
        for (Entry<T> entry : this.table) {
            while (entry != null && entry.next != null) {
                ++collisions;
                entry = entry.next;
            }
        }
        DaoLog.d("load: " + (float)this.size / (float)this.capacity + ", size: " + this.size + ", capa: " + this.capacity + ", collisions: " + collisions + ", collision ratio: " + (float)collisions / (float)this.size);
    }

    static final class Entry<T> {
        final long key;
        T value;
        Entry<T> next;

        Entry(long key, T value, Entry<T> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

