/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.identityscope;

import de.greenrobot.dao.identityscope.IdentityScope;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class IdentityScopeObject<K, T>
implements IdentityScope<K, T> {
    private final HashMap<K, Reference<T>> map = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public T get(K key) {
        Reference<T> ref;
        this.lock.lock();
        try {
            ref = this.map.get(key);
        }
        finally {
            this.lock.unlock();
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public T getNoLock(K key) {
        Reference<T> ref = this.map.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    @Override
    public void put(K key, T entity) {
        this.lock.lock();
        try {
            this.map.put(key, new WeakReference<T>(entity));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putNoLock(K key, T entity) {
        this.map.put(key, new WeakReference<T>(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detach(K key, T entity) {
        this.lock.lock();
        try {
            if (this.get(key) == entity && entity != null) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(K key) {
        this.lock.lock();
        try {
            this.map.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Iterable<K> keys) {
        this.lock.lock();
        try {
            for (K key : keys) {
                this.map.remove(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void reserveRoom(int count) {
    }
}

