/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao;

import android.database.CrossProcessCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.AbstractDaoSession;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.DaoLog;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.identityscope.IdentityScope;
import de.greenrobot.dao.identityscope.IdentityScopeLong;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.internal.FastCursor;
import de.greenrobot.dao.internal.TableStatements;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractDao<T, K> {
    protected final SQLiteDatabase db;
    protected final DaoConfig config;
    protected IdentityScope<K, T> identityScope;
    protected IdentityScopeLong<T> identityScopeLong;
    protected TableStatements statements;
    protected final AbstractDaoSession session;
    protected final int pkOrdinal;

    public AbstractDao(DaoConfig config) {
        this(config, null);
    }

    public AbstractDao(DaoConfig config, AbstractDaoSession daoSession) {
        this.config = config;
        this.session = daoSession;
        this.db = config.db;
        this.identityScope = config.getIdentityScope();
        if (this.identityScope instanceof IdentityScopeLong) {
            this.identityScopeLong = (IdentityScopeLong)this.identityScope;
        }
        this.statements = config.statements;
        this.pkOrdinal = config.pkProperty != null ? config.pkProperty.ordinal : -1;
    }

    public AbstractDaoSession getSession() {
        return this.session;
    }

    TableStatements getStatements() {
        return this.config.statements;
    }

    public String getTablename() {
        return this.config.tablename;
    }

    public Property[] getProperties() {
        return this.config.properties;
    }

    public Property getPkProperty() {
        return this.config.pkProperty;
    }

    public String[] getAllColumns() {
        return this.config.allColumns;
    }

    public String[] getPkColumns() {
        return this.config.pkColumns;
    }

    public String[] getNonPkColumns() {
        return this.config.nonPkColumns;
    }

    public T load(K key) {
        T entity;
        this.assertSinglePk();
        if (key == null) {
            return null;
        }
        if (this.identityScope != null && (entity = this.identityScope.get(key)) != null) {
            return entity;
        }
        String sql = this.statements.getSelectByKey();
        String[] keyArray = new String[]{key.toString()};
        Cursor cursor = this.db.rawQuery(sql, keyArray);
        return this.loadUniqueAndCloseCursor(cursor);
    }

    public T loadByRowId(long rowId) {
        String[] idArray = new String[]{Long.toString(rowId)};
        Cursor cursor = this.db.rawQuery(this.statements.getSelectByRowId(), idArray);
        return this.loadUniqueAndCloseCursor(cursor);
    }

    protected T loadUniqueAndCloseCursor(Cursor cursor) {
        try {
            T t = this.loadUnique(cursor);
            return t;
        }
        finally {
            cursor.close();
        }
    }

    protected T loadUnique(Cursor cursor) {
        boolean available = cursor.moveToFirst();
        if (!available) {
            return null;
        }
        if (!cursor.isLast()) {
            throw new DaoException("Expected unique result, but count was " + cursor.getCount());
        }
        return this.loadCurrent(cursor, 0, true);
    }

    public List<T> loadAll() {
        Cursor cursor = this.db.rawQuery(this.statements.getSelectAll(), null);
        return this.loadAllAndCloseCursor(cursor);
    }

    public boolean detach(T entity) {
        if (this.identityScope != null) {
            K key = this.getKeyVerified(entity);
            return this.identityScope.detach(key, entity);
        }
        return false;
    }

    public void detachAll() {
        if (this.identityScope != null) {
            this.identityScope.clear();
        }
    }

    protected List<T> loadAllAndCloseCursor(Cursor cursor) {
        try {
            List<T> list = this.loadAllFromCursor(cursor);
            return list;
        }
        finally {
            cursor.close();
        }
    }

    public void insertInTx(Iterable<T> entities) {
        this.insertInTx(entities, this.isEntityUpdateable());
    }

    public void insertInTx(T ... entities) {
        this.insertInTx((Iterable<T>)Arrays.asList(entities), this.isEntityUpdateable());
    }

    public void insertInTx(Iterable<T> entities, boolean setPrimaryKey) {
        SQLiteStatement stmt = this.statements.getInsertStatement();
        this.executeInsertInTx(stmt, entities, setPrimaryKey);
    }

    public void insertOrReplaceInTx(Iterable<T> entities, boolean setPrimaryKey) {
        SQLiteStatement stmt = this.statements.getInsertOrReplaceStatement();
        this.executeInsertInTx(stmt, entities, setPrimaryKey);
    }

    public void insertOrReplaceInTx(Iterable<T> entities) {
        this.insertOrReplaceInTx(entities, this.isEntityUpdateable());
    }

    public void insertOrReplaceInTx(T ... entities) {
        this.insertOrReplaceInTx((Iterable<T>)Arrays.asList(entities), this.isEntityUpdateable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsertInTx(SQLiteStatement stmt, Iterable<T> entities, boolean setPrimaryKey) {
        this.db.beginTransaction();
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                if (this.identityScope != null) {
                    this.identityScope.lock();
                }
                try {
                    for (T entity : entities) {
                        this.bindValues(stmt, entity);
                        if (setPrimaryKey) {
                            long rowId = stmt.executeInsert();
                            this.updateKeyAfterInsertAndAttach(entity, rowId, false);
                            continue;
                        }
                        stmt.execute();
                    }
                }
                finally {
                    if (this.identityScope != null) {
                        this.identityScope.unlock();
                    }
                }
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public long insert(T entity) {
        return this.executeInsert(entity, this.statements.getInsertStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertWithoutSettingPk(T entity) {
        long rowId;
        SQLiteStatement stmt = this.statements.getInsertStatement();
        if (this.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.bindValues(stmt, entity);
                rowId = stmt.executeInsert();
            }
        }
        this.db.beginTransaction();
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.bindValues(stmt, entity);
                rowId = stmt.executeInsert();
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
        return rowId;
    }

    public long insertOrReplace(T entity) {
        return this.executeInsert(entity, this.statements.getInsertOrReplaceStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeInsert(T entity, SQLiteStatement stmt) {
        long rowId;
        if (this.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.bindValues(stmt, entity);
                rowId = stmt.executeInsert();
            }
        }
        this.db.beginTransaction();
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.bindValues(stmt, entity);
                rowId = stmt.executeInsert();
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
        this.updateKeyAfterInsertAndAttach(entity, rowId, true);
        return rowId;
    }

    protected void updateKeyAfterInsertAndAttach(T entity, long rowId, boolean lock) {
        if (rowId != -1L) {
            K key = this.updateKeyAfterInsert(entity, rowId);
            this.attachEntity(key, entity, lock);
        } else {
            DaoLog.w("Could not insert row (executeInsert returned -1)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> loadAllFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        if (count == 0) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(count);
        CursorWindow window = null;
        boolean useFastCursor = false;
        if (cursor instanceof CrossProcessCursor && (window = ((CrossProcessCursor)cursor).getWindow()) != null) {
            if (window.getNumRows() == count) {
                cursor = new FastCursor(window);
                useFastCursor = true;
            } else {
                DaoLog.d("Window vs. result size: " + window.getNumRows() + "/" + count);
            }
        }
        if (cursor.moveToFirst()) {
            if (this.identityScope != null) {
                this.identityScope.lock();
                this.identityScope.reserveRoom(count);
            }
            try {
                if (!useFastCursor && window != null && this.identityScope != null) {
                    this.loadAllUnlockOnWindowBounds(cursor, window, list);
                } else {
                    do {
                        list.add(this.loadCurrent(cursor, 0, false));
                    } while (cursor.moveToNext());
                }
            }
            finally {
                if (this.identityScope != null) {
                    this.identityScope.unlock();
                }
            }
        }
        return list;
    }

    private void loadAllUnlockOnWindowBounds(Cursor cursor, CursorWindow window, List<T> list) {
        int windowEnd = window.getStartPosition() + window.getNumRows();
        int row = 0;
        while (true) {
            list.add(this.loadCurrent(cursor, 0, false));
            if (++row >= windowEnd) {
                window = this.moveToNextUnlocked(cursor);
                if (window == null) break;
                windowEnd = window.getStartPosition() + window.getNumRows();
            } else if (!cursor.moveToNext()) break;
            ++row;
        }
    }

    private CursorWindow moveToNextUnlocked(Cursor cursor) {
        this.identityScope.unlock();
        try {
            if (cursor.moveToNext()) {
                CursorWindow cursorWindow = ((CrossProcessCursor)cursor).getWindow();
                return cursorWindow;
            }
            CursorWindow cursorWindow = null;
            return cursorWindow;
        }
        finally {
            this.identityScope.lock();
        }
    }

    protected final T loadCurrent(Cursor cursor, int offset, boolean lock) {
        K key;
        if (this.identityScopeLong != null) {
            T entity;
            if (offset != 0 && cursor.isNull(this.pkOrdinal + offset)) {
                return null;
            }
            long key2 = cursor.getLong(this.pkOrdinal + offset);
            T t = entity = lock ? this.identityScopeLong.get2(key2) : this.identityScopeLong.get2NoLock(key2);
            if (entity != null) {
                return entity;
            }
            entity = this.readEntity(cursor, offset);
            this.attachEntity(entity);
            if (lock) {
                this.identityScopeLong.put2(key2, entity);
            } else {
                this.identityScopeLong.put2NoLock(key2, entity);
            }
            return entity;
        }
        if (this.identityScope != null) {
            T entity;
            K key3 = this.readKey(cursor, offset);
            if (offset != 0 && key3 == null) {
                return null;
            }
            T t = entity = lock ? this.identityScope.get(key3) : this.identityScope.getNoLock(key3);
            if (entity != null) {
                return entity;
            }
            entity = this.readEntity(cursor, offset);
            this.attachEntity(key3, entity, lock);
            return entity;
        }
        if (offset != 0 && (key = this.readKey(cursor, offset)) == null) {
            return null;
        }
        T entity = this.readEntity(cursor, offset);
        this.attachEntity(entity);
        return entity;
    }

    protected final <O> O loadCurrentOther(AbstractDao<O, ?> dao, Cursor cursor, int offset) {
        return dao.loadCurrent(cursor, offset, true);
    }

    public List<T> queryRaw(String where, String ... selectionArg) {
        Cursor cursor = this.db.rawQuery(this.statements.getSelectAll() + where, selectionArg);
        return this.loadAllAndCloseCursor(cursor);
    }

    public Query<T> queryRawCreate(String where, Object ... selectionArg) {
        List<Object> argList = Arrays.asList(selectionArg);
        return this.queryRawCreateListArgs(where, argList);
    }

    public Query<T> queryRawCreateListArgs(String where, Collection<Object> selectionArg) {
        return Query.internalCreate(this, this.statements.getSelectAll() + where, selectionArg.toArray());
    }

    public void deleteAll() {
        this.db.execSQL("DELETE FROM '" + this.config.tablename + "'");
        if (this.identityScope != null) {
            this.identityScope.clear();
        }
    }

    public void delete(T entity) {
        this.assertSinglePk();
        K key = this.getKeyVerified(entity);
        this.deleteByKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByKey(K key) {
        this.assertSinglePk();
        SQLiteStatement stmt = this.statements.getDeleteStatement();
        if (this.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.deleteByKeyInsideSynchronized(key, stmt);
            }
        }
        this.db.beginTransaction();
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.deleteByKeyInsideSynchronized(key, stmt);
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
        if (this.identityScope != null) {
            this.identityScope.remove(key);
        }
    }

    private void deleteByKeyInsideSynchronized(K key, SQLiteStatement stmt) {
        if (key instanceof Long) {
            stmt.bindLong(1, ((Long)key).longValue());
        } else {
            if (key == null) {
                throw new DaoException("Cannot delete entity, key is null");
            }
            stmt.bindString(1, key.toString());
        }
        stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInTxInternal(Iterable<T> entities, Iterable<K> keys) {
        this.assertSinglePk();
        SQLiteStatement stmt = this.statements.getDeleteStatement();
        ArrayList<Object> keysToRemoveFromIdentityScope = null;
        this.db.beginTransaction();
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                if (this.identityScope != null) {
                    this.identityScope.lock();
                    keysToRemoveFromIdentityScope = new ArrayList<Object>();
                }
                try {
                    if (entities != null) {
                        for (Object entity : entities) {
                            K key = this.getKeyVerified(entity);
                            this.deleteByKeyInsideSynchronized(key, stmt);
                            if (keysToRemoveFromIdentityScope == null) continue;
                            keysToRemoveFromIdentityScope.add(key);
                        }
                    }
                    if (keys != null) {
                        for (Object key : keys) {
                            this.deleteByKeyInsideSynchronized(key, stmt);
                            if (keysToRemoveFromIdentityScope == null) continue;
                            keysToRemoveFromIdentityScope.add(key);
                        }
                    }
                }
                finally {
                    if (this.identityScope != null) {
                        this.identityScope.unlock();
                    }
                }
            }
            this.db.setTransactionSuccessful();
            if (keysToRemoveFromIdentityScope != null && this.identityScope != null) {
                this.identityScope.remove(keysToRemoveFromIdentityScope);
            }
        }
        finally {
            this.db.endTransaction();
        }
    }

    public void deleteInTx(Iterable<T> entities) {
        this.deleteInTxInternal(entities, null);
    }

    public void deleteInTx(T ... entities) {
        this.deleteInTxInternal(Arrays.asList(entities), null);
    }

    public void deleteByKeyInTx(Iterable<K> keys) {
        this.deleteInTxInternal(null, keys);
    }

    public void deleteByKeyInTx(K ... keys) {
        this.deleteInTxInternal(null, Arrays.asList(keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(T entity) {
        this.assertSinglePk();
        K key = this.getKeyVerified(entity);
        String sql = this.statements.getSelectByKey();
        String[] keyArray = new String[]{key.toString()};
        Cursor cursor = this.db.rawQuery(sql, keyArray);
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                throw new DaoException("Entity does not exist in the database anymore: " + entity.getClass() + " with key " + key);
            }
            if (!cursor.isLast()) {
                throw new DaoException("Expected unique result, but count was " + cursor.getCount());
            }
            this.readEntity(cursor, entity, 0);
            this.attachEntity(key, entity, true);
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T entity) {
        this.assertSinglePk();
        SQLiteStatement stmt = this.statements.getUpdateStatement();
        if (this.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.updateInsideSynchronized(entity, stmt, true);
            }
        }
        this.db.beginTransaction();
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                this.updateInsideSynchronized(entity, stmt, true);
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public QueryBuilder<T> queryBuilder() {
        return QueryBuilder.internalCreate(this);
    }

    protected void updateInsideSynchronized(T entity, SQLiteStatement stmt, boolean lock) {
        this.bindValues(stmt, entity);
        int index = this.config.allColumns.length + 1;
        K key = this.getKey(entity);
        if (key instanceof Long) {
            stmt.bindLong(index, ((Long)key).longValue());
        } else {
            if (key == null) {
                throw new DaoException("Cannot update entity without key - was it inserted before?");
            }
            stmt.bindString(index, key.toString());
        }
        stmt.execute();
        this.attachEntity(key, entity, lock);
    }

    protected final void attachEntity(K key, T entity, boolean lock) {
        this.attachEntity(entity);
        if (this.identityScope != null && key != null) {
            if (lock) {
                this.identityScope.put(key, entity);
            } else {
                this.identityScope.putNoLock(key, entity);
            }
        }
    }

    protected void attachEntity(T entity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInTx(Iterable<T> entities) {
        SQLiteStatement stmt = this.statements.getUpdateStatement();
        this.db.beginTransaction();
        RuntimeException txEx = null;
        try {
            SQLiteStatement sQLiteStatement = stmt;
            synchronized (sQLiteStatement) {
                if (this.identityScope != null) {
                    this.identityScope.lock();
                }
                try {
                    for (T entity : entities) {
                        this.updateInsideSynchronized(entity, stmt, false);
                    }
                }
                finally {
                    if (this.identityScope != null) {
                        this.identityScope.unlock();
                    }
                }
            }
            this.db.setTransactionSuccessful();
        }
        catch (RuntimeException e) {
            txEx = e;
        }
        finally {
            try {
                this.db.endTransaction();
            }
            catch (RuntimeException e) {
                if (txEx != null) {
                    DaoLog.w("Could not end transaction (rethrowing initial exception)", e);
                    throw txEx;
                }
                throw e;
            }
        }
    }

    public void updateInTx(T ... entities) {
        this.updateInTx((Iterable<T>)Arrays.asList(entities));
    }

    protected void assertSinglePk() {
        if (this.config.pkColumns.length != 1) {
            throw new DaoException(this + " (" + this.config.tablename + ") does not have a single-column primary key");
        }
    }

    public long count() {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)('\'' + this.config.tablename + '\''));
    }

    protected K getKeyVerified(T entity) {
        K key = this.getKey(entity);
        if (key == null) {
            if (entity == null) {
                throw new NullPointerException("Entity may not be null");
            }
            throw new DaoException("Entity has no key");
        }
        return key;
    }

    public SQLiteDatabase getDatabase() {
        return this.db;
    }

    protected abstract T readEntity(Cursor var1, int var2);

    protected abstract K readKey(Cursor var1, int var2);

    protected abstract void readEntity(Cursor var1, T var2, int var3);

    protected abstract void bindValues(SQLiteStatement var1, T var2);

    protected abstract K updateKeyAfterInsert(T var1, long var2);

    protected abstract K getKey(T var1);

    protected abstract boolean isEntityUpdateable();
}

