/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.internal;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.internal.SqlUtils;

public class TableStatements {
    private final SQLiteDatabase db;
    private final String tablename;
    private final String[] allColumns;
    private final String[] pkColumns;
    private volatile SQLiteStatement insertStatement;
    private volatile SQLiteStatement insertOrReplaceStatement;
    private volatile SQLiteStatement updateStatement;
    private volatile SQLiteStatement deleteStatement;
    private volatile String selectAll;
    private volatile String selectByKey;
    private volatile String selectByRowId;
    private volatile String selectKeys;

    public TableStatements(SQLiteDatabase db, String tablename, String[] allColumns, String[] pkColumns) {
        this.db = db;
        this.tablename = tablename;
        this.allColumns = allColumns;
        this.pkColumns = pkColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement getInsertStatement() {
        if (this.insertStatement == null) {
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.insertStatement == null) {
                    String sql = SqlUtils.createSqlInsert("INSERT INTO ", this.tablename, this.allColumns);
                    this.insertStatement = this.db.compileStatement(sql);
                }
            }
        }
        return this.insertStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement getInsertOrReplaceStatement() {
        if (this.insertOrReplaceStatement == null) {
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.insertOrReplaceStatement == null) {
                    String sql = SqlUtils.createSqlInsert("INSERT OR REPLACE INTO ", this.tablename, this.allColumns);
                    this.insertOrReplaceStatement = this.db.compileStatement(sql);
                }
            }
        }
        return this.insertOrReplaceStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement getDeleteStatement() {
        if (this.deleteStatement == null) {
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.deleteStatement == null) {
                    String sql = SqlUtils.createSqlDelete(this.tablename, this.pkColumns);
                    this.deleteStatement = this.db.compileStatement(sql);
                }
            }
        }
        return this.deleteStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement getUpdateStatement() {
        if (this.updateStatement == null) {
            TableStatements tableStatements = this;
            synchronized (tableStatements) {
                if (this.updateStatement == null) {
                    String sql = SqlUtils.createSqlUpdate(this.tablename, this.allColumns, this.pkColumns);
                    this.updateStatement = this.db.compileStatement(sql);
                }
            }
        }
        return this.updateStatement;
    }

    public String getSelectAll() {
        if (this.selectAll == null) {
            this.selectAll = SqlUtils.createSqlSelect(this.tablename, "T", this.allColumns, false);
        }
        return this.selectAll;
    }

    public String getSelectKeys() {
        if (this.selectKeys == null) {
            this.selectKeys = SqlUtils.createSqlSelect(this.tablename, "T", this.pkColumns, false);
        }
        return this.selectKeys;
    }

    public String getSelectByKey() {
        if (this.selectByKey == null) {
            StringBuilder builder = new StringBuilder(this.getSelectAll());
            builder.append("WHERE ");
            SqlUtils.appendColumnsEqValue(builder, "T", this.pkColumns);
            this.selectByKey = builder.toString();
        }
        return this.selectByKey;
    }

    public String getSelectByRowId() {
        if (this.selectByRowId == null) {
            this.selectByRowId = this.getSelectAll() + "WHERE ROWID=?";
        }
        return this.selectByRowId;
    }
}

