/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.gradle;

import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.greenrobot.greendao.codemodifier.Greendao3Generator;
import org.greenrobot.greendao.codemodifier.SchemaOptions;
import org.greenrobot.greendao.gradle.AndroidPluginSourceProvider;
import org.greenrobot.greendao.gradle.DetectEntityCandidatesTask;
import org.greenrobot.greendao.gradle.Greendao3GradlePlugin;
import org.greenrobot.greendao.gradle.GreendaoOptions;
import org.greenrobot.greendao.gradle.JavaPluginSourceProvider;
import org.greenrobot.greendao.gradle.SchemaOptionsExtension;
import org.greenrobot.greendao.gradle.SourceProvider;
import org.greenrobot.greendao.gradle.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J.\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\b\u0010!\u001a\u00020\u0006H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/greenrobot/greendao/gradle/Greendao3GradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "ANDROID_PLUGINS", "", "", "getANDROID_PLUGINS", "()Ljava/util/List;", "name", "getName", "()Ljava/lang/String;", "packageName", "getPackageName", "apply", "", "project", "collectSchemaOptions", "", "Lorg/greenrobot/greendao/codemodifier/SchemaOptions;", "daoPackage", "genSrcDir", "Ljava/io/File;", "options", "Lorg/greenrobot/greendao/gradle/GreendaoOptions;", "createGreendaoTask", "Lorg/gradle/api/Task;", "candidatesFile", "targetGenDir", "encoding", "version", "getSourceProvider", "Lorg/greenrobot/greendao/gradle/SourceProvider;", "getVersion", "greendao-gradle-plugin"})
public final class Greendao3GradlePlugin
implements Plugin<Project> {
    @NotNull
    private final String name = "greendao";
    @NotNull
    private final String packageName = "org/greenrobot/greendao";
    @NotNull
    private final List<String> ANDROID_PLUGINS = CollectionsKt.listOf((Object[])new String[]{"android", "android-library", "com.android.application", "com.android.library", "com.android.feature"});

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getLogger().debug(this.name + " plugin starting...");
        project.getExtensions().create(this.name, GreendaoOptions.class, new Object[]{project});
        project.afterEvaluate((Action)new Action<Project>(this, project){
            final /* synthetic */ Greendao3GradlePlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                File file;
                boolean writeToBuildFolder;
                String version = Greendao3GradlePlugin.access$getVersion(this.this$0);
                this.$project.getLogger().debug(this.this$0.getName() + " plugin " + version + " preparing tasks...");
                File candidatesFile = this.$project.file((Object)("build/cache/" + this.this$0.getName() + "-candidates.list"));
                SourceProvider sourceProvider = Greendao3GradlePlugin.access$getSourceProvider(this.this$0, this.$project);
                String string = sourceProvider.getEncoding();
                if (string == null) {
                    string = "UTF-8";
                }
                String encoding = string;
                Map taskArgs = MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", DetectEntityCandidatesTask.class));
                Task task = this.$project.task(taskArgs, this.this$0.getName() + "Prepare");
                if (task == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.greenrobot.greendao.gradle.DetectEntityCandidatesTask");
                }
                DetectEntityCandidatesTask prepareTask = (DetectEntityCandidatesTask)task;
                prepareTask.setSourceFiles((FileCollection)sourceProvider.sourceTree().matching((Closure)UtilKt.Closure(apply.1.INSTANCE)));
                prepareTask.setCandidatesListFile(candidatesFile);
                prepareTask.setVersion(version);
                prepareTask.setCharset(encoding);
                prepareTask.setGroup(this.this$0.getName());
                prepareTask.setDescription("Finds entity source files for " + this.this$0.getName());
                GreendaoOptions options = (GreendaoOptions)this.$project.getExtensions().getByType(GreendaoOptions.class);
                boolean bl = writeToBuildFolder = options.getTargetGenDir() == null;
                if (writeToBuildFolder) {
                    file = new File(this.$project.getBuildDir(), "generated/source/" + this.this$0.getName());
                } else {
                    file = options.getTargetGenDir();
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                }
                File targetGenDir = file;
                File file2 = candidatesFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"candidatesFile");
                GreendaoOptions greendaoOptions = options;
                Intrinsics.checkExpressionValueIsNotNull((Object)greendaoOptions, (String)"options");
                Task greendaoTask = Greendao3GradlePlugin.access$createGreendaoTask(this.this$0, this.$project, file2, greendaoOptions, targetGenDir, encoding, version);
                greendaoTask.dependsOn(new Object[]{prepareTask});
                sourceProvider.addGeneratorTask(greendaoTask, targetGenDir, writeToBuildFolder);
            }
            {
                this.this$0 = greendao3GradlePlugin;
                this.$project = project;
            }
        });
    }

    private final Task createGreendaoTask(Project project, File candidatesFile, GreendaoOptions options, File targetGenDir, String encoding, String version) {
        Task generateTask2;
        Map<String, SchemaOptions> schemaOptions;
        Task task = project.task(this.name);
        boolean bl = false;
        boolean bl2 = false;
        Task $this$apply = task;
        boolean bl3 = false;
        $this$apply.getLogging().captureStandardOutput(LogLevel.INFO);
        $this$apply.getInputs().file((Object)candidatesFile);
        $this$apply.getInputs().property("plugin-version", (Object)version);
        $this$apply.getInputs().property("source-encoding", (Object)encoding);
        Map<String, SchemaOptions> $this$forEach$iv = schemaOptions = this.collectSchemaOptions(options.getDaoPackage(), targetGenDir, options);
        boolean $i$f$forEach = false;
        Map<String, SchemaOptions> map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, SchemaOptions>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SchemaOptions> element$iv;
            Map.Entry<String, SchemaOptions> e = element$iv = iterator.next();
            boolean bl5 = false;
            $this$apply.getInputs().property("schema-" + e.getKey(), (Object)e.getValue().toString());
        }
        ConfigurableFileTree outputFileTree2 = project.fileTree((Object)targetGenDir, (Closure)UtilKt.Closure(createGreendaoTask.generateTask.1.outputFileTree.1.INSTANCE));
        $this$apply.getOutputs().files(new Object[]{outputFileTree2});
        if (options.getGenerateTests()) {
            $this$apply.getOutputs().dir((Object)options.getTargetGenDirTests());
        }
        $this$apply.doLast((Action)new Action<Task>(schemaOptions, this, candidatesFile, version, encoding, options, targetGenDir, project){
            final /* synthetic */ Map $schemaOptions;
            final /* synthetic */ Greendao3GradlePlugin this$0;
            final /* synthetic */ File $candidatesFile$inlined;
            final /* synthetic */ String $version$inlined;
            final /* synthetic */ String $encoding$inlined;
            final /* synthetic */ GreendaoOptions $options$inlined;
            final /* synthetic */ File $targetGenDir$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$schemaOptions = map;
                this.this$0 = greendao3GradlePlugin;
                this.$candidatesFile$inlined = file;
                this.$version$inlined = string;
                this.$encoding$inlined = string2;
                this.$options$inlined = greendaoOptions;
                this.$targetGenDir$inlined = file2;
                this.$project$inlined = project;
            }

            public final void execute(Task it) {
                boolean bl = this.$candidatesFile$inlined.exists();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Candidates file does not exist. Can't continue";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Iterable candidatesFiles2 = SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)FilesKt.readLines$default((File)this.$candidatesFile$inlined, null, (int)1, null)), (int)1), (Function1)createGreendaoTask.generateTask.1.candidatesFiles.1.INSTANCE));
                new Greendao3Generator(this.$options$inlined.getFormatting$greendao_gradle_plugin().getData$greendao_gradle_plugin(), this.$options$inlined.getSkipTestGeneration(), this.$encoding$inlined).run(candidatesFiles2, this.$schemaOptions);
            }
        });
        Task task2 = generateTask2 = task;
        Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"generateTask");
        task2.setGroup(this.name);
        generateTask2.setDescription("Generates source files for " + this.name);
        return generateTask2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getVersion() {
        String string;
        InputStream stream;
        Properties properties = new Properties();
        InputStream inputStream = stream = this.getClass().getResourceAsStream('/' + this.packageName + "/gradle/version.properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                try {
                    properties.load(it);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if ((string = properties.getProperty("version")) == null) {
            string = "Unknown (bad build)";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, SchemaOptions> collectSchemaOptions(String daoPackage, File genSrcDir, GreendaoOptions options) {
        void $this$mapTo$iv$iv;
        SchemaOptions defaultOptions = new SchemaOptions("default", options.getSchemaVersion(), daoPackage, genSrcDir, options.getGenerateTests() ? options.getTargetGenDirTests() : null);
        Map schemaOptions = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"default", (Object)defaultOptions)});
        Map<String, SchemaOptionsExtension> $this$map$iv = options.getSchemas$greendao_gradle_plugin().getSchemasMap();
        boolean $i$f$map = false;
        Map<String, SchemaOptionsExtension> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Pair pair = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = pair.entrySet().iterator();
        while (iterator.hasNext()) {
            File file;
            void name;
            void e;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = e;
            void var18_19 = string;
            boolean bl3 = false;
            String string2 = (String)var18_19.getKey();
            var18_19 = string;
            bl3 = false;
            SchemaOptionsExtension schemaExt = (SchemaOptionsExtension)var18_19.getValue();
            void v0 = name;
            Integer n = schemaExt.getVersion();
            int n2 = n != null ? n.intValue() : defaultOptions.getVersion();
            String string3 = schemaExt.getDaoPackage();
            if (string3 == null) {
                String string4 = defaultOptions.getDaoPackage();
                if (string4 != null) {
                    string = string4;
                    int n3 = n2;
                    void var23_25 = v0;
                    boolean bl4 = false;
                    bl3 = false;
                    String it = string;
                    boolean bl5 = false;
                    String string5 = it + '.' + (String)name;
                    v0 = var23_25;
                    n2 = n3;
                    string3 = string5;
                } else {
                    string3 = null;
                }
            }
            File file2 = defaultOptions.getOutputDir();
            if (options.getGenerateTests()) {
                file = schemaExt.getTargetGenDirTests();
                if (file == null) {
                    file = defaultOptions.getTestsOutputDir();
                }
            } else {
                file = null;
            }
            File file3 = file;
            File file4 = file2;
            String string6 = string3;
            int n4 = n2;
            void var35_35 = v0;
            SchemaOptions schemaOptions2 = new SchemaOptions((String)var35_35, n4, string6, file4, file3);
            collection.add(schemaOptions2);
        }
        Iterable $this$associateTo$iv = (List)destination$iv$iv;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map2 = schemaOptions;
            SchemaOptions it = (SchemaOptions)element$iv;
            boolean bl6 = false;
            pair = TuplesKt.to((Object)it.getName(), (Object)it);
            bl = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return schemaOptions;
    }

    @NotNull
    public final List<String> getANDROID_PLUGINS() {
        return this.ANDROID_PLUGINS;
    }

    private final SourceProvider getSourceProvider(Project project) {
        boolean bl;
        block5: {
            if (project.getPlugins().hasPlugin("java")) {
                return new JavaPluginSourceProvider(project);
            }
            Iterable $this$any$iv = this.ANDROID_PLUGINS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!project.getPlugins().hasPlugin(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return new AndroidPluginSourceProvider(project);
        }
        throw (Throwable)new RuntimeException("ObjectBox supports only Java and Android projects. None of the corresponding plugins have been applied to the project.");
    }

    public static final /* synthetic */ String access$getVersion(Greendao3GradlePlugin $this) {
        return $this.getVersion();
    }

    public static final /* synthetic */ SourceProvider access$getSourceProvider(Greendao3GradlePlugin $this, Project project) {
        return $this.getSourceProvider(project);
    }

    public static final /* synthetic */ Task access$createGreendaoTask(Greendao3GradlePlugin $this, Project project, File candidatesFile, GreendaoOptions options, File targetGenDir, String encoding, String version) {
        return $this.createGreendaoTask(project, candidatesFile, options, targetGenDir, encoding, version);
    }
}

