/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.daogenerator;

import de.greenrobot.daogenerator.Entity;
import de.greenrobot.daogenerator.Property;
import de.greenrobot.daogenerator.PropertyType;
import de.greenrobot.daogenerator.Schema;
import de.greenrobot.daogenerator.ToManyBase;
import java.util.List;

public class ToMany
extends ToManyBase {
    private Property[] sourceProperties;
    private final Property[] targetProperties;

    public ToMany(Schema schema, Entity sourceEntity, Property[] sourceProperties, Entity targetEntity, Property[] targetProperties) {
        super(schema, sourceEntity, targetEntity);
        this.sourceProperties = sourceProperties;
        this.targetProperties = targetProperties;
    }

    public Property[] getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(Property[] sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public Property[] getTargetProperties() {
        return this.targetProperties;
    }

    @Override
    void init2ndPass() {
        int count;
        super.init2ndPass();
        if (this.sourceProperties == null) {
            List<Property> pks = this.sourceEntity.getPropertiesPk();
            if (pks.isEmpty()) {
                throw new RuntimeException("Source entity has no primary key, but we need it for " + this);
            }
            this.sourceProperties = new Property[pks.size()];
            this.sourceProperties = pks.toArray(this.sourceProperties);
        }
        if ((count = this.sourceProperties.length) != this.targetProperties.length) {
            throw new RuntimeException("Source properties do not match target properties: " + this);
        }
        for (int i = 0; i < count; ++i) {
            Property sourceProperty = this.sourceProperties[i];
            Property targetProperty = this.targetProperties[i];
            PropertyType sourceType = sourceProperty.getPropertyType();
            PropertyType targetType = targetProperty.getPropertyType();
            if (sourceType == null || targetType == null) {
                throw new RuntimeException("Property type uninitialized");
            }
            if (sourceType == targetType) continue;
            System.err.println("Warning to-one property type does not match target key type: " + this);
        }
    }

    @Override
    void init3rdPass() {
        super.init3rdPass();
    }
}

