/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMultimap<K, V, C extends Collection<V>>
implements Map<K, C> {
    protected Map<K, C> map;

    protected AbstractMultimap(Map<K, C> map) {
        this.map = map;
    }

    protected abstract C createNewCollection();

    @Override
    public void putAll(Map<? extends K, ? extends C> m) {
        this.map.putAll(m);
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized C get(Object key) {
        return (C)((Collection)this.map.get(key));
    }

    @Override
    public synchronized C remove(Object key) {
        return (C)((Collection)this.map.remove(key));
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Collection<C> values() {
        return this.map.values();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    public synchronized int putElement(K key, V value) {
        Collection<Object> collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createNewCollection();
            this.map.put(key, collection);
        }
        collection.add(value);
        return collection.size();
    }

    @Override
    public synchronized C put(K key, C value) {
        return (C)((Collection)this.map.put(key, value));
    }

    @Override
    public synchronized Set<Map.Entry<K, C>> entrySet() {
        return this.map.entrySet();
    }

    public synchronized boolean putElements(K key, Collection<V> values) {
        Collection<Object> collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createNewCollection();
            this.map.put(key, collection);
        }
        return collection.addAll(values);
    }

    public synchronized boolean removeElement(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        boolean removed = collection.remove(value);
        if (collection.isEmpty()) {
            this.map.remove(key);
        }
        return removed;
    }

    public synchronized int countElements(K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public synchronized int countElements() {
        int count = 0;
        for (Collection collection : this.map.values()) {
            count += collection.size();
        }
        return count;
    }

    public synchronized boolean containsElement(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public synchronized boolean containsElement(V value) {
        for (Collection collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public synchronized C valuesElements() {
        C all = this.createNewCollection();
        for (Collection collection : this.map.values()) {
            all.addAll(collection);
        }
        return all;
    }
}

