/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.hash;

import java.util.zip.Checksum;
import org.greenrobot.essentials.PrimitiveArrayUtils;

public class Murmur3A
implements Checksum {
    private static PrimitiveArrayUtils primitiveArrayUtils = PrimitiveArrayUtils.getInstance();
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private int h1;
    private int length;
    private int partialK1;
    private int partialK1Pos;

    public Murmur3A() {
        this.seed = 0;
    }

    public Murmur3A(int seed) {
        this.seed = seed;
        this.h1 = seed;
    }

    @Override
    public void update(int b) {
        switch (this.partialK1Pos) {
            case 0: {
                this.partialK1 = 0xFF & b;
                this.partialK1Pos = 1;
                break;
            }
            case 1: {
                this.partialK1 |= (0xFF & b) << 8;
                this.partialK1Pos = 2;
                break;
            }
            case 2: {
                this.partialK1 |= (0xFF & b) << 16;
                this.partialK1Pos = 3;
                break;
            }
            case 3: {
                this.partialK1 |= (0xFF & b) << 24;
                this.applyK1(this.partialK1);
                this.partialK1Pos = 0;
            }
        }
        ++this.length;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        int i;
        while (this.partialK1Pos != 0 && len > 0) {
            this.update(b[off]);
            ++off;
            --len;
        }
        int remainder = len & 3;
        int stop = off + len - remainder;
        for (i = off; i < stop; i += 4) {
            int k1 = primitiveArrayUtils.getIntLE(b, i);
            this.applyK1(k1);
        }
        this.length += stop - off;
        for (i = 0; i < remainder; ++i) {
            this.update(b[stop + i]);
        }
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    public void updateShort(short value) {
        switch (this.partialK1Pos) {
            case 0: {
                this.partialK1 = value & 0xFFFF;
                this.partialK1Pos = 2;
                break;
            }
            case 1: {
                this.partialK1 |= (value & 0xFFFF) << 8;
                this.partialK1Pos = 3;
                break;
            }
            case 2: {
                this.partialK1 |= (value & 0xFFFF) << 16;
                this.applyK1(this.partialK1);
                this.partialK1Pos = 0;
                break;
            }
            case 3: {
                this.partialK1 |= (value & 0xFF) << 24;
                this.applyK1(this.partialK1);
                this.partialK1 = value >> 8 & 0xFF;
                this.partialK1Pos = 1;
            }
        }
        this.length += 2;
    }

    public void updateShort(short ... values) {
        int len = values.length;
        if (len > 0 && (this.partialK1Pos == 0 || this.partialK1Pos == 2)) {
            int off = 0;
            if (this.partialK1Pos == 2) {
                this.partialK1 |= (values[0] & 0xFFFF) << 16;
                this.applyK1(this.partialK1);
                this.partialK1Pos = 0;
                --len;
                off = 1;
            }
            int joinBeforeIdx = off + (len & 0xFFFFFFFE);
            for (int i = off; i < joinBeforeIdx; i += 2) {
                int joined = 0xFFFF & values[i] | (values[i + 1] & 0xFFFF) << 16;
                this.applyK1(joined);
            }
            if (joinBeforeIdx < values.length) {
                this.partialK1 = values[joinBeforeIdx] & 0xFFFF;
                this.partialK1Pos = 2;
            }
            this.length += 2 * values.length;
        } else {
            for (short value : values) {
                this.updateShort(value);
            }
        }
    }

    public void updateInt(int value) {
        switch (this.partialK1Pos) {
            case 0: {
                this.applyK1(value);
                break;
            }
            case 1: {
                this.partialK1 |= (value & 0xFFFFFF) << 8;
                this.applyK1(this.partialK1);
                this.partialK1 = value >>> 24;
                break;
            }
            case 2: {
                this.partialK1 |= (value & 0xFFFF) << 16;
                this.applyK1(this.partialK1);
                this.partialK1 = value >>> 16;
                break;
            }
            case 3: {
                this.partialK1 |= (value & 0xFF) << 24;
                this.applyK1(this.partialK1);
                this.partialK1 = value >>> 8;
            }
        }
        this.length += 4;
    }

    public void updateInt(int ... values) {
        if (this.partialK1Pos == 0) {
            for (int value : values) {
                this.applyK1(value);
            }
            this.length += 4 * values.length;
        } else {
            for (int value : values) {
                this.updateInt(value);
            }
        }
    }

    public void updateLong(long value) {
        switch (this.partialK1Pos) {
            case 0: {
                this.applyK1((int)(value & 0xFFFFFFFFFFFFFFFFL));
                this.applyK1((int)(value >>> 32));
                break;
            }
            case 1: {
                this.partialK1 = (int)((long)this.partialK1 | (value & 0xFFFFFFL) << 8);
                this.applyK1(this.partialK1);
                this.applyK1((int)(value >>> 24 & 0xFFFFFFFFFFFFFFFFL));
                this.partialK1 = (int)(value >>> 56);
                break;
            }
            case 2: {
                this.partialK1 = (int)((long)this.partialK1 | (value & 0xFFFFL) << 16);
                this.applyK1(this.partialK1);
                this.applyK1((int)(value >>> 16 & 0xFFFFFFFFFFFFFFFFL));
                this.partialK1 = (int)(value >>> 48);
                break;
            }
            case 3: {
                this.partialK1 = (int)((long)this.partialK1 | (value & 0xFFL) << 24);
                this.applyK1(this.partialK1);
                this.applyK1((int)(value >>> 8 & 0xFFFFFFFFFFFFFFFFL));
                this.partialK1 = (int)(value >>> 40);
            }
        }
        this.length += 8;
    }

    public void updateLong(long ... values) {
        if (this.partialK1Pos == 0) {
            for (long value : values) {
                this.applyK1((int)(value & 0xFFFFFFFFFFFFFFFFL));
                this.applyK1((int)(value >>> 32));
            }
            this.length += 8 * values.length;
        } else {
            for (long value : values) {
                this.updateLong(value);
            }
        }
    }

    public void updateFloat(float number) {
        this.updateInt(Float.floatToIntBits(number));
    }

    public void updateDouble(double number) {
        this.updateLong(Double.doubleToLongBits(number));
    }

    public void updateBoolean(boolean value) {
        this.update(value ? 1 : 0);
    }

    private void applyK1(int k1) {
        k1 *= -862048943;
        k1 = k1 << 15 | k1 >>> 17;
        this.h1 ^= (k1 *= 461845907);
        this.h1 = this.h1 << 13 | this.h1 >>> 19;
        this.h1 = this.h1 * 5 + -430675100;
    }

    @Override
    public long getValue() {
        int finished = this.h1;
        if (this.partialK1Pos > 0) {
            int k1 = this.partialK1 * -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            finished ^= (k1 *= 461845907);
        }
        finished ^= this.length;
        finished ^= finished >>> 16;
        finished *= -2048144789;
        finished ^= finished >>> 13;
        finished *= -1028477387;
        finished ^= finished >>> 16;
        return 0xFFFFFFFFL & (long)finished;
    }

    @Override
    public void reset() {
        this.h1 = this.seed;
        this.length = 0;
        this.partialK1Pos = 0;
    }
}

