/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.collections;

import java.util.Arrays;

public class LongHashMap<T> {
    protected static final int DEFAULT_CAPACITY = 16;
    private Entry<T>[] table;
    private int capacity;
    private int threshold;
    private volatile int size;

    public static <T> LongHashMap<T> createSynchronized() {
        return new Synchronized(16);
    }

    public static <T> LongHashMap<T> createSynchronized(int capacity) {
        return new Synchronized(capacity);
    }

    public LongHashMap() {
        this(16);
    }

    public LongHashMap(int capacity) {
        this.capacity = capacity;
        this.threshold = capacity * 4 / 3;
        this.table = new Entry[capacity];
    }

    public boolean containsKey(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T get(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public T put(long key, T value) {
        Entry<T> entryOriginal;
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> entry = entryOriginal = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                Object oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
            entry = entry.next;
        }
        this.table[index] = new Entry<T>(key, value, entryOriginal);
        ++this.size;
        if (this.size > this.threshold) {
            this.setCapacity(2 * this.capacity);
        }
        return null;
    }

    public T remove(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry<T> previous = null;
        Entry<T> entry = this.table[index];
        while (entry != null) {
            Entry next = entry.next;
            if (entry.key == key) {
                if (previous == null) {
                    this.table[index] = next;
                } else {
                    previous.next = next;
                }
                --this.size;
                return entry.value;
            }
            previous = entry;
            entry = next;
        }
        return null;
    }

    public long[] keys() {
        long[] values = new long[this.size];
        int idx = 0;
        for (Entry<T> entry : this.table) {
            while (entry != null) {
                values[idx++] = entry.key;
                entry = entry.next;
            }
        }
        return values;
    }

    public Entry<T>[] entries() {
        Entry[] entries = new Entry[this.size];
        int idx = 0;
        for (Entry<T> entry : this.table) {
            while (entry != null) {
                entries[idx++] = entry;
                entry = entry.next;
            }
        }
        return entries;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    public int size() {
        return this.size;
    }

    public void setCapacity(int newCapacity) {
        Entry[] newTable = new Entry[newCapacity];
        for (Entry<T> entry : this.table) {
            while (entry != null) {
                long key = entry.key;
                int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % newCapacity;
                Entry originalNext = entry.next;
                entry.next = newTable[index];
                newTable[index] = entry;
                entry = originalNext;
            }
        }
        this.table = newTable;
        this.capacity = newCapacity;
        this.threshold = newCapacity * 4 / 3;
    }

    public void reserveRoom(int entryCount) {
        this.setCapacity(entryCount * 5 / 3);
    }

    protected static class Synchronized<T>
    extends LongHashMap<T> {
        public Synchronized(int capacity) {
            super(capacity);
        }

        @Override
        public synchronized boolean containsKey(long key) {
            return super.containsKey(key);
        }

        @Override
        public synchronized T get(long key) {
            return super.get(key);
        }

        @Override
        public synchronized T put(long key, T value) {
            return super.put(key, value);
        }

        @Override
        public synchronized T remove(long key) {
            return super.remove(key);
        }

        @Override
        public synchronized long[] keys() {
            return super.keys();
        }

        @Override
        public synchronized Entry<T>[] entries() {
            return super.entries();
        }

        @Override
        public synchronized void clear() {
            super.clear();
        }

        @Override
        public synchronized void setCapacity(int newCapacity) {
            super.setCapacity(newCapacity);
        }

        @Override
        public synchronized void reserveRoom(int entryCount) {
            super.reserveRoom(entryCount);
        }
    }

    public static final class Entry<T> {
        public final long key;
        public T value;
        Entry<T> next;

        Entry(long key, T value, Entry<T> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

