/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.multiple;

import java.util.Date;
import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogMessageIF;
import org.graylog2.syslog4j.SyslogMessageProcessorIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.multiple.MultipleSyslogConfig;

public class MultipleSyslog
implements SyslogIF {
    private static final long serialVersionUID = 587308197526365108L;
    protected String syslogProtocol = null;
    protected MultipleSyslogConfig multipleSyslogConfig = null;

    @Override
    public void initialize(String protocol, SyslogConfigIF config) throws SyslogRuntimeException {
        this.syslogProtocol = protocol;
        try {
            this.multipleSyslogConfig = (MultipleSyslogConfig)config;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type MultipleSyslogConfig");
        }
    }

    @Override
    public SyslogConfigIF getConfig() {
        return this.multipleSyslogConfig;
    }

    @Override
    public void debug(String message) {
        this.log(7, message);
    }

    @Override
    public void debug(SyslogMessageIF message) {
        this.log(7, message);
    }

    @Override
    public void critical(String message) {
        this.log(2, message);
    }

    @Override
    public void critical(SyslogMessageIF message) {
        this.log(2, message);
    }

    @Override
    public void error(String message) {
        this.log(3, message);
    }

    @Override
    public void error(SyslogMessageIF message) {
        this.log(3, message);
    }

    @Override
    public void alert(String message) {
        this.log(1, message);
    }

    @Override
    public void alert(SyslogMessageIF message) {
        this.log(1, message);
    }

    @Override
    public void notice(String message) {
        this.log(5, message);
    }

    @Override
    public void notice(SyslogMessageIF message) {
        this.log(5, message);
    }

    @Override
    public void emergency(String message) {
        this.log(0, message);
    }

    @Override
    public void emergency(SyslogMessageIF message) {
        this.log(0, message);
    }

    @Override
    public void info(String message) {
        this.log(6, message);
    }

    @Override
    public void info(SyslogMessageIF message) {
        this.log(6, message);
    }

    @Override
    public void warn(String message) {
        this.log(4, message);
    }

    @Override
    public void warn(SyslogMessageIF message) {
        this.log(4, message);
    }

    @Override
    public void log(int level, String message) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.log(level, message);
        }
    }

    @Override
    public void log(int level, SyslogMessageIF message) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.log(level, message);
        }
    }

    @Override
    public void flush() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.flush();
        }
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.shutdown();
        }
    }

    @Override
    public void backLog(int level, String message, Throwable reasonThrowable) {
    }

    @Override
    public void backLog(int level, String message, String reason) {
    }

    @Override
    public void setMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    @Override
    public SyslogMessageProcessorIF getMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    @Override
    public void setStructuredMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    @Override
    public SyslogMessageProcessorIF getStructuredMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    @Override
    public String getProtocol() {
        return this.syslogProtocol;
    }

    @Override
    public void log(int level, String message, Date datetime) {
    }

    @Override
    public void log(int level, SyslogMessageIF message, Date datetime) {
    }
}

