/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GelfMessage {
    private static final String ID_NAME = "id";
    private static final String GELF_VERSION = "1.1";
    private static final byte[] GELF_CHUNKED_ID = new byte[]{30, 15};
    private static final int MAXIMUM_CHUNK_SIZE = 1420;
    private static final BigDecimal TIME_DIVISOR = new BigDecimal(1000);
    private String version = "1.1";
    private String host;
    private byte[] hostBytes = this.lastFourAsciiBytes("none");
    private String shortMessage;
    private String fullMessage;
    private long javaTimestamp;
    private String level;
    private String facility = "gelf-java";
    private String line;
    private String file;
    private Map<String, Object> additonalFields = new HashMap<String, Object>();

    public GelfMessage() {
    }

    public GelfMessage(String shortMessage, String fullMessage, long timestamp, String level) {
        this(shortMessage, fullMessage, timestamp, level, null, null);
    }

    public GelfMessage(String shortMessage, String fullMessage, long timestamp, String level, String line, String file) {
        this.shortMessage = shortMessage;
        this.fullMessage = fullMessage;
        this.javaTimestamp = timestamp;
        this.level = level;
        this.line = line;
        this.file = file;
    }

    public String toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.getVersion());
        map.put("host", this.getHost());
        map.put("short_message", this.getShortMessage());
        map.put("full_message", this.getFullMessage());
        map.put("timestamp", this.getTimestamp());
        map.put("facility", this.getFacility());
        try {
            map.put("level", Long.parseLong(this.getLevel()));
        }
        catch (NumberFormatException e) {
            map.put("level", 6L);
        }
        if (null != this.getFile()) {
            map.put("file", this.getFile());
        }
        if (null != this.getLine()) {
            try {
                map.put("line", Long.parseLong(this.getLine()));
            }
            catch (NumberFormatException e) {
                map.put("line", -1L);
            }
        }
        for (Map.Entry<String, Object> additionalField : this.additonalFields.entrySet()) {
            if (ID_NAME.equals(additionalField.getKey())) continue;
            map.put("_" + additionalField.getKey(), additionalField.getValue());
        }
        return JSONValue.toJSONString(map);
    }

    public ByteBuffer[] toUDPBuffers() {
        byte[] messageBytes = this.gzipMessage(this.toJson());
        int diagrams_length = messageBytes.length / 1420;
        if (messageBytes.length % 1420 != 0) {
            ++diagrams_length;
        }
        ByteBuffer[] datagrams = new ByteBuffer[diagrams_length];
        if (messageBytes.length > 1420) {
            this.sliceDatagrams(messageBytes, datagrams);
        } else {
            datagrams[0] = ByteBuffer.allocate(messageBytes.length);
            datagrams[0].put(messageBytes);
            datagrams[0].flip();
        }
        return datagrams;
    }

    public ByteBuffer toTCPBuffer() {
        byte[] messageBytes;
        try {
            String json = this.toJson();
            json = json + '\u0000';
            messageBytes = json.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8 support available.", e);
        }
        ByteBuffer buffer = ByteBuffer.allocate(messageBytes.length);
        buffer.put(messageBytes);
        buffer.flip();
        return buffer;
    }

    public ByteBuffer toAMQPBuffer() {
        byte[] messageBytes = this.gzipMessage(this.toJson());
        ByteBuffer buffer = ByteBuffer.allocate(messageBytes.length);
        buffer.put(messageBytes);
        buffer.flip();
        return buffer;
    }

    private void sliceDatagrams(byte[] messageBytes, ByteBuffer[] datagrams) {
        int messageLength = messageBytes.length;
        byte[] messageId = ByteBuffer.allocate(8).putInt(this.getCurrentMillis()).put(this.hostBytes).array();
        int num = datagrams.length;
        for (int idx = 0; idx < num; ++idx) {
            byte[] header = this.concatByteArray(GELF_CHUNKED_ID, this.concatByteArray(messageId, new byte[]{(byte)idx, (byte)num}));
            int from = idx * 1420;
            int to = from + 1420;
            if (to >= messageLength) {
                to = messageLength;
            }
            byte[] range = new byte[to - from + 1];
            System.arraycopy(messageBytes, from, range, 0, range.length - 1);
            byte[] datagram = this.concatByteArray(header, range);
            datagrams[idx] = ByteBuffer.allocate(datagram.length);
            datagrams[idx].put(datagram);
            datagrams[idx].flip();
        }
    }

    public int getCurrentMillis() {
        return (int)System.currentTimeMillis();
    }

    private byte[] gzipMessage(String message) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] bytes;
            GZIPOutputStream stream = new GZIPOutputStream(bos);
            try {
                bytes = message.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("No UTF-8 support available.", e);
            }
            stream.write(bytes);
            stream.finish();
            stream.close();
            byte[] zipped = bos.toByteArray();
            bos.close();
            return zipped;
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] lastFourAsciiBytes(String host) {
        String shortHost = host.length() >= 4 ? host.substring(host.length() - 4) : host;
        try {
            return shortHost.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM without ascii support?", e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.hostBytes = this.lastFourAsciiBytes(host);
    }

    public String getShortMessage() {
        return !this.isEmpty(this.shortMessage) ? this.shortMessage : "<empty>";
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    public String getTimestamp() {
        return new BigDecimal(this.javaTimestamp).divide(TIME_DIVISOR).toPlainString();
    }

    public Long getJavaTimestamp() {
        return this.javaTimestamp;
    }

    public void setJavaTimestamp(long javaTimestamp) {
        this.javaTimestamp = javaTimestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public GelfMessage addField(String key, String value) {
        this.getAdditonalFields().put(key, value);
        return this;
    }

    public GelfMessage addField(String key, Object value) {
        this.getAdditonalFields().put(key, value);
        return this;
    }

    public Map<String, Object> getAdditonalFields() {
        return this.additonalFields;
    }

    public void setAdditonalFields(Map<String, Object> additonalFields) {
        this.additonalFields = new HashMap<String, Object>(additonalFields);
    }

    public boolean isValid() {
        return this.isShortOrFullMessagesExists() && !this.isEmpty(this.version) && !this.isEmpty(this.host) && !this.isEmpty(this.facility);
    }

    private boolean isShortOrFullMessagesExists() {
        return !this.isEmpty(this.shortMessage) || !this.isEmpty(this.fullMessage);
    }

    public boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    byte[] concatByteArray(byte[] first, byte[] second) {
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

