/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.UUID;
import org.graylog2.GelfMessage;
import org.graylog2.GelfSender;

public class GelfAMQPSender
implements GelfSender {
    private volatile boolean shutdown = false;
    private final ConnectionFactory factory = new ConnectionFactory();
    private Connection connection;
    private Channel channel;
    private final String exchangeName;
    private final String routingKey;
    private final int maxRetries;
    private final String channelMutex = "channelMutex";

    public GelfAMQPSender(String host, String exchangeName, String routingKey, int maxRetries) throws IOException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.factory.setUri(host);
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.maxRetries = maxRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown) return false;
        if (!message.isValid()) {
            return false;
        }
        String uuid = UUID.randomUUID().toString();
        String messageid = "gelf" + message.getHost() + message.getFacility() + message.getTimestamp() + uuid;
        int tries = 0;
        while (true) {
            try {
                if (this.channel == null) {
                    String string = "channelMutex";
                    // MONITORENTER : "channelMutex"
                    if (this.channel == null) {
                        this.connection = this.factory.newConnection();
                        this.channel = this.connection.createChannel();
                        this.channel.confirmSelect();
                    }
                    // MONITOREXIT : string
                }
                AMQP.BasicProperties.Builder propertiesBuilder = new AMQP.BasicProperties.Builder();
                propertiesBuilder.contentType("application/json; charset=utf-8");
                propertiesBuilder.contentEncoding("gzip");
                propertiesBuilder.messageId(messageid);
                propertiesBuilder.timestamp(new Date(message.getJavaTimestamp()));
                AMQP.BasicProperties properties = propertiesBuilder.build();
                this.channel.basicPublish(this.exchangeName, this.routingKey, properties, message.toAMQPBuffer().array());
                this.channel.waitForConfirms();
                return true;
            }
            catch (Exception e) {
                this.channel = null;
                if (++tries <= this.maxRetries || this.maxRetries < 0) continue;
                return false;
            }
            break;
        }
    }

    public void close() {
        this.shutdown = true;
        try {
            this.channel.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

