/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.client.impl.UnknownChannelException;
import com.rabbitmq.utility.IntAllocator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class ChannelManager {
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 10;
    private final Object monitor = new Object();
    private final Map<Integer, ChannelN> _channelMap = new HashMap<Integer, ChannelN>();
    private final IntAllocator channelNumberAllocator;
    private final ConsumerWorkService workService;
    private final Set<CountDownLatch> shutdownSet = new HashSet<CountDownLatch>();
    private final int _channelMax;

    public int getChannelMax() {
        return this._channelMax;
    }

    public ChannelManager(ConsumerWorkService workService, int channelMax) {
        if (channelMax == 0) {
            channelMax = 65535;
        }
        this._channelMax = channelMax;
        this.channelNumberAllocator = new IntAllocator(1, channelMax);
        this.workService = workService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN getChannel(int channelNumber) {
        Object object = this.monitor;
        synchronized (object) {
            ChannelN ch = this._channelMap.get(channelNumber);
            if (ch == null) {
                throw new UnknownChannelException(channelNumber);
            }
            return ch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSignal(ShutdownSignalException signal) {
        HashSet<ChannelN> channels;
        Object object = this.monitor;
        synchronized (object) {
            channels = new HashSet<ChannelN>(this._channelMap.values());
        }
        for (ChannelN channel : channels) {
            this.releaseChannelNumber(channel);
            channel.processShutdownSignal(signal, true, true);
            this.shutdownSet.add(channel.getShutdownLatch());
            channel.notifyListeners();
        }
        this.scheduleShutdownProcessing();
    }

    private void scheduleShutdownProcessing() {
        final HashSet<CountDownLatch> sdSet = new HashSet<CountDownLatch>(this.shutdownSet);
        final ConsumerWorkService ssWorkService = this.workService;
        Thread shutdownThread = new Thread(new Runnable(){

            public void run() {
                for (CountDownLatch latch : sdSet) {
                    try {
                        latch.await(10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable) {}
                }
                ssWorkService.shutdown();
            }
        }, "ConsumerWorkServiceShutdown");
        shutdownThread.setDaemon(true);
        shutdownThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection connection) throws IOException {
        ChannelN ch;
        Object object = this.monitor;
        synchronized (object) {
            int channelNumber = this.channelNumberAllocator.allocate();
            if (channelNumber == -1) {
                return null;
            }
            ch = this.addNewChannel(connection, channelNumber);
        }
        ch.open();
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection connection, int channelNumber) throws IOException {
        ChannelN ch;
        Object object = this.monitor;
        synchronized (object) {
            if (!this.channelNumberAllocator.reserve(channelNumber)) {
                return null;
            }
            ch = this.addNewChannel(connection, channelNumber);
        }
        ch.open();
        return ch;
    }

    private ChannelN addNewChannel(AMQConnection connection, int channelNumber) throws IOException {
        if (this._channelMap.containsKey(channelNumber)) {
            throw new IllegalStateException("We have attempted to create a channel with a number that is already in use. This should never happen. Please report this as a bug.");
        }
        ChannelN ch = new ChannelN(connection, channelNumber, this.workService);
        this._channelMap.put(ch.getChannelNumber(), ch);
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseChannelNumber(ChannelN channel) {
        Object object = this.monitor;
        synchronized (object) {
            int channelNumber = channel.getChannelNumber();
            ChannelN existing = this._channelMap.remove(channelNumber);
            if (existing == null) {
                return;
            }
            if (existing != channel) {
                this._channelMap.put(channelNumber, existing);
                return;
            }
            this.channelNumberAllocator.free(channelNumber);
        }
    }
}

