/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.GelfMessageVersion;

public class GelfMessage {
    private final GelfMessageVersion version;
    private final String host;
    private final String message;
    private String fullMessage;
    private double timestamp = (double)System.currentTimeMillis() / 1000.0;
    private GelfMessageLevel level = GelfMessageLevel.ALERT;
    private final Map<String, Object> additionalFields = new HashMap<String, Object>();

    public GelfMessage(String message) {
        this(message, "localhost");
    }

    public GelfMessage(String message, String host) {
        this(message, host, GelfMessageVersion.V1_1);
    }

    public GelfMessage(String message, String host, GelfMessageVersion version) {
        this.message = message;
        this.host = host;
        this.version = version;
    }

    public GelfMessageVersion getVersion() {
        return this.version;
    }

    public String getHost() {
        return this.host;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(double timestamp) {
        this.timestamp = timestamp;
    }

    public GelfMessageLevel getLevel() {
        return this.level;
    }

    public void setLevel(GelfMessageLevel level) {
        this.level = level;
    }

    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    public void addAdditionalField(String key, Object value) {
        if (key == null) {
            return;
        }
        this.additionalFields.put(key, value);
    }

    public void addAdditionalFields(Map<String, Object> additionalFields) {
        this.additionalFields.putAll(additionalFields);
    }

    public String toString() {
        return String.format("GelfMessage{version=\"%s\" timestamp=\"%.3f\" short_message=\"%s\", level=\"%s\"}", new Object[]{this.version, this.timestamp, this.message, this.level});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GelfMessage that = (GelfMessage)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (this.level != that.level) {
            return false;
        }
        if (Double.compare(that.timestamp, this.timestamp) != 0) {
            return false;
        }
        return !(this.fullMessage != null ? !this.fullMessage.equals(that.fullMessage) : that.fullMessage != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.host, this.message, this.fullMessage, this.level, this.timestamp});
    }
}

