/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.graphstream.graph.Element;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Rule;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.Style;

public class StyleGroup
extends Style
implements Iterable<Element> {
    protected String id;
    protected ArrayList<Rule> rules = new ArrayList();
    protected HashMap<String, Element> elements = new HashMap();
    protected StyleGroupSet.EventSet eventSet;
    protected HashMap<Element, ElementEvents> eventsFor;
    protected HashSet<Element> dynamicOnes;
    protected String[] curEvents;
    protected BulkElements bulkElements = new BulkElements();
    public HashMap<String, GraphicElement.SwingElementRenderer> renderers;

    public StyleGroup(String identifier, Collection<Rule> rules, Element firstElement, StyleGroupSet.EventSet eventSet) {
        this.id = identifier;
        this.rules.addAll(rules);
        this.elements.put(firstElement.getId(), firstElement);
        this.values = null;
        this.eventSet = eventSet;
        for (Rule rule : rules) {
            rule.addGroup(identifier);
        }
    }

    public String getId() {
        return this.id;
    }

    public Selector.Type getType() {
        return this.rules.get((int)0).selector.type;
    }

    public boolean hasDynamicElements() {
        return this.dynamicOnes != null && this.dynamicOnes.size() > 0;
    }

    public boolean hasEventElements() {
        return this.eventsFor != null && this.eventsFor.size() > 0;
    }

    public boolean elementHasEvents(Element element) {
        return this.eventsFor != null && this.eventsFor.containsKey(element);
    }

    public boolean elementIsDynamic(Element element) {
        return this.dynamicOnes != null && this.dynamicOnes.contains(element);
    }

    @Override
    public Object getValue(String property, String ... events) {
        int n = this.rules.size();
        if (events == null || events.length == 0) {
            if (this.curEvents != null && this.curEvents.length > 0) {
                events = this.curEvents;
            } else if (this.eventSet.events != null && this.eventSet.events.length > 0) {
                events = this.eventSet.events;
            }
        }
        int i = 1;
        while (i < n) {
            Style style = this.rules.get(i).getStyle();
            if (style.hasValue(property, events)) {
                return style.getValue(property, events);
            }
            ++i;
        }
        return this.rules.get(0).getStyle().getValue(property, events);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean contains(String elementId) {
        return this.elements.containsKey(elementId);
    }

    public boolean contains(Element element) {
        return this.elements.containsKey(element.getId());
    }

    public Element getElement(String id) {
        return this.elements.get(id);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public Iterator<? extends Element> getElementIterator() {
        return this.elements.values().iterator();
    }

    public Iterable<? extends Element> elements() {
        return this.elements.values();
    }

    public Iterable<? extends Element> bulkElements() {
        return this.bulkElements;
    }

    public Iterable<ElementEvents> elementsEvents() {
        return this.eventsFor.values();
    }

    public Iterable<Element> dynamicElements() {
        return this.dynamicOnes;
    }

    @Override
    public Iterator<Element> iterator() {
        return this.elements.values().iterator();
    }

    public GraphicElement.SwingElementRenderer getRenderer(String id) {
        if (this.renderers != null) {
            return this.renderers.get(id);
        }
        return null;
    }

    public ElementEvents getEventsFor(Element element) {
        if (this.eventsFor != null) {
            return this.eventsFor.get(element);
        }
        return null;
    }

    public boolean isElementDynamic(Element element) {
        if (this.dynamicOnes != null) {
            return this.dynamicOnes.contains(element);
        }
        return false;
    }

    public void addElement(Element element) {
        this.elements.put(element.getId(), element);
    }

    public Element removeElement(Element element) {
        if (this.eventsFor != null && this.eventsFor.containsKey(element)) {
            this.eventsFor.remove(element);
        }
        if (this.dynamicOnes != null && this.dynamicOnes.contains(element)) {
            this.dynamicOnes.remove(element);
        }
        return this.elements.remove(element.getId());
    }

    protected void pushEventFor(Element element, String event) {
        if (this.elements.containsKey(element.getId())) {
            ElementEvents evs;
            if (this.eventsFor == null) {
                this.eventsFor = new HashMap();
            }
            if ((evs = this.eventsFor.get(element)) == null) {
                evs = new ElementEvents(element, this, event);
                this.eventsFor.put(element, evs);
            } else {
                evs.pushEvent(event);
            }
        }
    }

    protected void popEventFor(Element element, String event) {
        if (this.elements.containsKey(element.getId()) && this.eventsFor != null) {
            ElementEvents evs = this.eventsFor.get(element);
            if (evs != null) {
                evs.popEvent(event);
                if (evs.eventCount() == 0) {
                    this.eventsFor.remove(element);
                }
            }
            if (this.eventsFor.isEmpty()) {
                this.eventsFor = null;
            }
        }
    }

    public void activateEventsFor(Element element) {
        ElementEvents evs = this.eventsFor.get(element);
        if (evs != null && this.curEvents == null) {
            this.curEvents = evs.events();
        }
    }

    public void deactivateEvents() {
        this.curEvents = null;
    }

    protected void pushElementAsDynamic(Element element) {
        if (this.dynamicOnes == null) {
            this.dynamicOnes = new HashSet();
        }
        this.dynamicOnes.add(element);
    }

    protected void popElementAsDynamic(Element element) {
        this.dynamicOnes.remove(element);
        if (this.dynamicOnes.isEmpty()) {
            this.dynamicOnes = null;
        }
    }

    public void release() {
        for (Rule rule : this.rules) {
            rule.removeGroup(this.id);
        }
        this.elements.clear();
    }

    @Override
    public void setValue(String property, Object value) {
        throw new RuntimeException("you cannot change the values of a style group.");
    }

    public void addRenderer(String id, GraphicElement.SwingElementRenderer renderer) {
        if (this.renderers == null) {
            this.renderers = new HashMap();
        }
        this.renderers.put(id, renderer);
    }

    public GraphicElement.SwingElementRenderer removeRenderer(String id) {
        return this.renderers.remove(id);
    }

    @Override
    public String toString() {
        return this.toString(-1);
    }

    @Override
    public String toString(int level) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        String sprefix = "    ";
        int i = 0;
        while (i < level) {
            prefix = String.valueOf(prefix) + sprefix;
            ++i;
        }
        builder.append(String.format("%s%s%n", prefix, this.id));
        builder.append(String.format("%s%sContains : ", prefix, sprefix));
        for (Element element : this.elements.values()) {
            builder.append(String.format("%s ", element.getId()));
        }
        builder.append(String.format("%n%s%sStyle : ", prefix, sprefix));
        for (Rule rule : this.rules) {
            builder.append(String.format("%s ", rule.selector.toString()));
        }
        builder.append(String.format("%n", new Object[0]));
        return builder.toString();
    }

    protected class BulkElements
    implements Iterable<Element> {
        protected BulkElements() {
        }

        @Override
        public Iterator<Element> iterator() {
            return new BulkIterator(StyleGroup.this.elements.values().iterator());
        }
    }

    protected class BulkIterator
    implements Iterator<Element> {
        protected Iterator<Element> iterator;
        Element next;

        public BulkIterator(Iterator<Element> iterator) {
            this.iterator = iterator;
            boolean loop = true;
            while (loop && iterator.hasNext()) {
                this.next = iterator.next();
                if (!StyleGroup.this.elementHasEvents(this.next) && !StyleGroup.this.elementIsDynamic(this.next)) {
                    loop = false;
                    continue;
                }
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            Element e = this.next;
            boolean loop = true;
            this.next = null;
            while (loop && this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!StyleGroup.this.elementIsDynamic(this.next) && !StyleGroup.this.elementHasEvents(this.next)) {
                    loop = false;
                    continue;
                }
                this.next = null;
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("this iterator does not allows removing elements");
        }
    }

    public static class ElementEvents {
        protected String[] events;
        protected Element element;
        protected StyleGroup group;

        protected ElementEvents(Element element, StyleGroup group, String event) {
            this.element = element;
            this.group = group;
            this.events = new String[1];
            this.events[0] = event;
        }

        public Element getElement() {
            return this.element;
        }

        public int eventCount() {
            if (this.events == null) {
                return 0;
            }
            return this.events.length;
        }

        public String[] events() {
            return this.events;
        }

        public void activate() {
            this.group.activateEventsFor(this.element);
        }

        public void deactivate() {
            this.group.deactivateEvents();
        }

        protected void pushEvent(String event) {
            int n = this.events.length + 1;
            String[] e = new String[n];
            boolean found = false;
            int i = 0;
            while (i < this.events.length) {
                if (!this.events[i].equals(event)) {
                    e[i] = this.events[i];
                } else {
                    found = true;
                }
                ++i;
            }
            e[this.events.length] = event;
            if (!found) {
                this.events = e;
            }
        }

        protected void popEvent(String event) {
            if (this.events.length > 1) {
                String[] e = new String[this.events.length - 1];
                boolean found = false;
                int i = 0;
                int j = 0;
                while (i < this.events.length) {
                    if (!this.events[i].equals(event)) {
                        if (j < e.length) {
                            e[j++] = this.events[i];
                        }
                    } else {
                        found = true;
                    }
                    ++i;
                }
                if (found) {
                    this.events = e;
                }
            } else if (this.events[0].equals(event)) {
                this.events = null;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s events {", this.element.getId()));
            String[] stringArray = this.events;
            int n = this.events.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                builder.append(String.format(" %s", event));
                ++n2;
            }
            builder.append(" }");
            return builder.toString();
        }
    }
}

