/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Source;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.LayoutRunner;
import org.graphstream.ui.layout.Layouts;
import org.graphstream.ui.swingViewer.DefaultView;
import org.graphstream.ui.swingViewer.GraphRenderer;
import org.graphstream.ui.swingViewer.ViewPanel;
import org.graphstream.ui.swingViewer.basicRenderer.SwingBasicGraphRenderer;
import org.graphstream.ui.view.Camera;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.ViewerPipe;

public class Viewer
implements ActionListener {
    private static final Logger logger = Logger.getLogger(Viewer.class.getName());
    public static String DEFAULT_VIEW_ID = "defaultView";
    protected boolean graphInAnotherThread = true;
    protected GraphicGraph graph;
    protected ProxyPipe pumpPipe;
    protected Source sourceInSameThread;
    protected Timer timer;
    protected int delay = 40;
    protected final Map<String, View> views = new TreeMap<String, View>();
    protected CloseFramePolicy closeFramePolicy = CloseFramePolicy.EXIT;
    protected LayoutRunner optLayout = null;
    protected ProxyPipe layoutPipeIn = null;

    public Viewer(ProxyPipe source) {
        this.graphInAnotherThread = true;
        this.init(new GraphicGraph(this.newGGId()), source, null);
    }

    public Viewer(GraphicGraph graph) {
        this.graphInAnotherThread = false;
        this.init(graph, null, null);
    }

    public Viewer(Graph graph, ThreadingModel threadingModel) {
        switch (threadingModel) {
            case GRAPH_IN_GUI_THREAD: {
                this.graphInAnotherThread = false;
                this.init(new GraphicGraph(this.newGGId()), null, graph);
                this.enableXYZfeedback(true);
                break;
            }
            case GRAPH_IN_ANOTHER_THREAD: {
                this.graphInAnotherThread = true;
                ThreadProxyPipe tpp = new ThreadProxyPipe();
                tpp.init(graph, true);
                this.init(new GraphicGraph(this.newGGId()), tpp, null);
                this.enableXYZfeedback(false);
                break;
            }
            case GRAPH_ON_NETWORK: {
                throw new RuntimeException("TO DO, sorry !:-)");
            }
        }
    }

    protected String newGGId() {
        return String.format("GraphicGraph_%d", (int)(Math.random() * 10000.0));
    }

    protected void init(GraphicGraph graph, ProxyPipe ppipe, Source source) {
        this.graph = graph;
        this.pumpPipe = ppipe;
        this.sourceInSameThread = source;
        this.timer = new Timer(this.delay, this);
        assert (ppipe != null && source == null || ppipe == null && source != null);
        if (this.pumpPipe != null) {
            this.pumpPipe.addSink(graph);
        }
        if (this.sourceInSameThread != null) {
            if (source instanceof Graph) {
                this.replayGraph((Graph)source);
            }
            this.sourceInSameThread.addSink(graph);
        }
        this.timer.setCoalesce(true);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.disableAutoLayout();
            for (View view : this.views.values()) {
                view.close(this.graph);
            }
            this.timer.stop();
            this.timer.removeActionListener(this);
            if (this.pumpPipe != null) {
                this.pumpPipe.removeSink(this.graph);
            }
            if (this.sourceInSameThread != null) {
                this.sourceInSameThread.removeSink(this.graph);
            }
            this.graph = null;
            this.pumpPipe = null;
            this.sourceInSameThread = null;
            this.timer = null;
        }
    }

    public static GraphRenderer newGraphRenderer() {
        String rendererClassName;
        try {
            rendererClassName = System.getProperty("gs.ui.renderer");
            if (rendererClassName != null) {
                logger.warning("\"gs.ui.renderer\" is deprecated, use \"org.graphstream.ui.renderer\" instead.");
            } else {
                rendererClassName = System.getProperty("org.graphstream.ui.renderer");
            }
        }
        catch (AccessControlException e) {
            rendererClassName = null;
        }
        if (rendererClassName == null) {
            return new SwingBasicGraphRenderer();
        }
        try {
            Class<?> c = Class.forName(rendererClassName);
            Object object = c.newInstance();
            if (object instanceof GraphRenderer) {
                return (GraphRenderer)object;
            }
            logger.warning(String.format("Class '%s' is not a 'GraphRenderer'.", object));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot create graph renderer.", e);
        }
        return new SwingBasicGraphRenderer();
    }

    public CloseFramePolicy getCloseFramePolicy() {
        return this.closeFramePolicy;
    }

    public ProxyPipe newThreadProxyOnGraphicGraph() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.graph);
        return tpp;
    }

    public ViewerPipe newViewerPipe() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.graph, false);
        this.enableXYZfeedback(true);
        return new ViewerPipe(String.format("viewer_%d", (int)(Math.random() * 10000.0)), tpp);
    }

    public GraphicGraph getGraphicGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getView(String id) {
        Map<String, View> map = this.views;
        synchronized (map) {
            return this.views.get(id);
        }
    }

    public ViewPanel getDefaultView() {
        return (DefaultView)this.getView(DEFAULT_VIEW_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewPanel addDefaultView(boolean openInAFrame) {
        Map<String, View> map = this.views;
        synchronized (map) {
            DefaultView view = new DefaultView(this, DEFAULT_VIEW_ID, Viewer.newGraphRenderer());
            this.addView(view);
            if (openInAFrame) {
                view.openInAFrame(true);
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addView(View view) {
        Map<String, View> map = this.views;
        synchronized (map) {
            View old = this.views.put(view.getId(), view);
            if (old != null && old != view) {
                old.close(this.graph);
            }
            return old;
        }
    }

    public ViewPanel addView(String id, GraphRenderer renderer) {
        return this.addView(id, renderer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewPanel addView(String id, GraphRenderer renderer, boolean openInAFrame) {
        Map<String, View> map = this.views;
        synchronized (map) {
            DefaultView view = new DefaultView(this, id, renderer);
            this.addView(view);
            if (openInAFrame) {
                view.openInAFrame(true);
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(String id) {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.views.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Map<String, View> map = this.views;
        synchronized (map) {
            boolean changed;
            if (this.pumpPipe != null) {
                this.pumpPipe.pump();
            }
            if (this.layoutPipeIn != null) {
                this.layoutPipeIn.pump();
            }
            if (changed = this.graph.graphChangedFlag()) {
                this.computeGraphMetrics();
                for (View view : this.views.values()) {
                    view.display(this.graph, changed);
                }
            }
            this.graph.resetGraphChangedFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeGraphMetrics() {
        this.graph.computeBounds();
        Map<String, View> map = this.views;
        synchronized (map) {
            Point3 lo = this.graph.getMinPos();
            Point3 hi = this.graph.getMaxPos();
            for (View view : this.views.values()) {
                Camera camera = view.getCamera();
                if (camera == null) continue;
                camera.setBounds(lo.x, lo.y, lo.z, hi.x, hi.y, hi.z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseFramePolicy(CloseFramePolicy policy) {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.closeFramePolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableXYZfeedback(boolean on) {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.graph.feedbackXYZ(on);
        }
    }

    public void enableAutoLayout() {
        this.enableAutoLayout(Layouts.newLayoutAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutoLayout(Layout layoutAlgorithm) {
        Map<String, View> map = this.views;
        synchronized (map) {
            if (this.optLayout == null) {
                this.optLayout = new LayoutRunner(this.graph, layoutAlgorithm, true, false);
                this.graph.replay();
                this.layoutPipeIn = this.optLayout.newLayoutPipe();
                this.layoutPipeIn.addAttributeSink(this.graph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAutoLayout() {
        Map<String, View> map = this.views;
        synchronized (map) {
            if (this.optLayout != null) {
                ((ThreadProxyPipe)this.layoutPipeIn).unregisterFromSource();
                this.layoutPipeIn.removeSink(this.graph);
                this.layoutPipeIn = null;
                this.optLayout.release();
                this.optLayout = null;
            }
        }
    }

    protected void replayGraph(Graph graph) {
        if (graph.getAttributeKeySet() != null) {
            for (String key : graph.getAttributeKeySet()) {
                this.graph.addAttribute(key, graph.getAttribute(key));
            }
        }
        for (Node node : graph) {
            Object n = this.graph.addNode(node.getId());
            if (node.getAttributeKeySet() == null) continue;
            for (String key : node.getAttributeKeySet()) {
                n.addAttribute(key, node.getAttribute(key));
            }
        }
        for (Edge edge : graph.getEachEdge()) {
            Object e = this.graph.addEdge(edge.getId(), edge.getSourceNode().getId(), edge.getTargetNode().getId(), edge.isDirected());
            if (edge.getAttributeKeySet() == null) continue;
            for (String key : edge.getAttributeKeySet()) {
                e.addAttribute(key, edge.getAttribute(key));
            }
        }
    }

    public static enum ThreadingModel {
        GRAPH_IN_GUI_THREAD,
        GRAPH_IN_ANOTHER_THREAD,
        GRAPH_ON_NETWORK;

    }

    public static enum CloseFramePolicy {
        CLOSE_VIEWER,
        HIDE_ONLY,
        EXIT;

    }
}

