/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.graphstream.ui.swingViewer.util.DefaultCamera;

public class ImageCache {
    private static final Logger logger = Logger.getLogger(DefaultCamera.class.getSimpleName());
    protected final Map<String, Image> imageCache = new TreeMap<String, Image>();
    protected final Image dummy;
    protected static ImageCache defaultImageCache;

    public ImageCache() {
        BufferedImage img = new BufferedImage(16, 16, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(Color.RED);
        g2.drawRect(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2.drawLine(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2.drawLine(0, img.getHeight() - 1, img.getWidth() - 1, 0);
        this.dummy = img;
    }

    public static ImageCache defaultImageCache() {
        if (defaultImageCache == null) {
            defaultImageCache = new ImageCache();
        }
        return defaultImageCache;
    }

    public Image getImage(String fileNameOrUrl) {
        return this.getImage(fileNameOrUrl, false);
    }

    public Image getImage(String fileNameOrUrl, boolean forceTryReload) {
        Image ii = this.imageCache.get(fileNameOrUrl);
        if (ii == this.dummy && !forceTryReload) {
            return null;
        }
        if (ii == null) {
            URL url = ImageCache.class.getClassLoader().getResource(fileNameOrUrl);
            if (url != null) {
                try {
                    ii = ImageIO.read(url);
                    this.imageCache.put(fileNameOrUrl, ii);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    url = new URL(fileNameOrUrl);
                    ii = ImageIO.read(url);
                    this.imageCache.put(fileNameOrUrl, ii);
                }
                catch (Exception e) {
                    try {
                        ii = ImageIO.read(new File(fileNameOrUrl));
                        this.imageCache.put(fileNameOrUrl, ii);
                    }
                    catch (IOException ee) {
                        this.imageCache.put(fileNameOrUrl, this.dummy);
                        logger.log(Level.WARNING, String.format("Cannot read image '%s'.", fileNameOrUrl), e);
                    }
                }
            }
        }
        return ii;
    }

    public Image getDummyImage() {
        return this.dummy;
    }
}

