/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import org.graphstream.ui.view.Camera;
import org.graphstream.ui.view.util.CubicCurve;

public class DefaultCamera
implements Camera {
    private static final Logger logger = Logger.getLogger(DefaultCamera.class.getSimpleName());
    protected GraphicGraph graph = null;
    protected GraphMetrics metrics = new GraphMetrics();
    protected boolean autoFit = true;
    protected Point3 center = new Point3();
    protected double zoom;
    protected AffineTransform Tx = new AffineTransform();
    protected AffineTransform xT;
    protected AffineTransform oldTx;
    protected double rotation;
    protected Values padding = new Values(StyleConstants.Units.GU, 0.0, 0.0, 0.0);
    protected HashSet<String> nodeInvisible = new HashSet();
    protected double[] gviewport = null;
    protected double gviewportDiagonal = 0.0;

    public DefaultCamera(GraphicGraph graph) {
        this.graph = graph;
    }

    @Override
    public Point3 getViewCenter() {
        return this.center;
    }

    @Override
    public void setViewCenter(double x, double y, double z) {
        this.setAutoFitView(false);
        this.center.set(x, y, z);
        this.graph.graphChanged = true;
    }

    public void setViewCenter(double x, double y) {
        this.setViewCenter(x, y, 0.0);
    }

    @Override
    public double getViewPercent() {
        return this.zoom;
    }

    @Override
    public void setViewPercent(double percent) {
        this.setAutoFitView(false);
        this.setZoom(percent);
        this.graph.graphChanged = true;
    }

    @Override
    public double getViewRotation() {
        return this.rotation;
    }

    @Override
    public GraphMetrics getMetrics() {
        return this.metrics;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.format("Camera :%n", new Object[0]));
        builder.append(String.format("    autoFit  = %b%n", this.autoFit));
        builder.append(String.format("    center   = %s%n", this.center));
        builder.append(String.format("    rotation = %f%n", this.rotation));
        builder.append(String.format("    zoom     = %f%n", this.zoom));
        builder.append(String.format("    padding  = %s%n", this.padding));
        builder.append(String.format("    metrics  = %s%n", this.metrics));
        return builder.toString();
    }

    @Override
    public void resetView() {
        this.setAutoFitView(true);
        this.setViewRotation(0.0);
    }

    @Override
    public void setBounds(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.metrics.setBounds(minx, miny, minz, maxx, maxy, maxz);
    }

    @Override
    public double getGraphDimension() {
        if (this.gviewport != null) {
            return this.gviewportDiagonal;
        }
        return this.metrics.diagonal;
    }

    @Override
    public boolean isVisible(GraphicElement element) {
        if (this.autoFit) {
            return !element.hidden && element.style.getVisibilityMode() != StyleConstants.VisibilityMode.HIDDEN;
        }
        switch (element.getSelectorType()) {
            case NODE: {
                return !this.nodeInvisible.contains(element.getId());
            }
            case EDGE: {
                return this.isEdgeVisible((GraphicEdge)element);
            }
            case SPRITE: {
                return this.isSpriteVisible((GraphicSprite)element);
            }
        }
        return false;
    }

    @Override
    public Point3 transformPxToGu(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        this.xT.transform(p, p);
        return new Point3(p.x, p.y, 0.0);
    }

    @Override
    public Point3 transformGuToPx(double x, double y, double z) {
        Point2D.Double p = new Point2D.Double(x, y);
        this.Tx.transform(p, p);
        return new Point3(p.x, p.y, 0.0);
    }

    public void checkVisibility(GraphicGraph graph) {
        double X = this.metrics.viewport[0];
        double Y = this.metrics.viewport[1];
        double W = this.metrics.viewport[2];
        double H = this.metrics.viewport[3];
        this.nodeInvisible.clear();
        for (Node node : graph) {
            boolean visible = this.isNodeIn((GraphicNode)node, X, Y, X + W, Y + H) && !((GraphicNode)node).hidden && ((GraphicNode)node).positionned;
            if (visible) continue;
            this.nodeInvisible.add(node.getId());
        }
    }

    public GraphicElement findNodeOrSpriteAt(GraphicGraph graph, double x, double y) {
        for (Node node : graph) {
            GraphicNode node2 = (GraphicNode)node;
            if (!this.nodeContains(node2, x, y)) continue;
            return node2;
        }
        for (GraphicSprite graphicSprite : graph.spriteSet()) {
            if (!this.spriteContains(graphicSprite, x, y)) continue;
            return graphicSprite;
        }
        return null;
    }

    public Collection<GraphicElement> allNodesOrSpritesIn(GraphicGraph graph, double x1, double y1, double x2, double y2) {
        ArrayList<GraphicElement> elts = new ArrayList<GraphicElement>();
        for (Node node : graph) {
            if (!this.isNodeIn((GraphicNode)node, x1, y1, x2, y2)) continue;
            elts.add((GraphicNode)node);
        }
        for (GraphicSprite graphicSprite : graph.spriteSet()) {
            if (!this.isSpriteIn(graphicSprite, x1, y1, x2, y2)) continue;
            elts.add(graphicSprite);
        }
        return Collections.unmodifiableList(elts);
    }

    public Point2D.Double getSpritePosition(GraphicSprite sprite, Point2D.Double pos, StyleConstants.Units units) {
        if (sprite.isAttachedToNode()) {
            return this.getSpritePositionNode(sprite, pos, units);
        }
        if (sprite.isAttachedToEdge()) {
            return this.getSpritePositionEdge(sprite, pos, units);
        }
        return this.getSpritePositionFree(sprite, pos, units);
    }

    public double[] getGraphViewport() {
        return this.gviewport;
    }

    @Override
    public void setGraphViewport(double minx, double miny, double maxx, double maxy) {
        this.setAutoFitView(false);
        this.setViewCenter(minx + (maxx - minx) / 2.0, miny + (maxy - miny) / 2.0);
        this.gviewport = new double[4];
        this.gviewport[0] = minx;
        this.gviewport[1] = miny;
        this.gviewport[2] = maxx;
        this.gviewport[3] = maxy;
        this.gviewportDiagonal = Math.sqrt((maxx - minx) * (maxx - minx) + (maxy - miny) * (maxy - miny));
        this.setZoom(1.0);
    }

    @Override
    public void removeGraphViewport() {
        logger.fine("Graph viewport removed for [" + this + "].");
        this.gviewport = null;
        this.resetView();
    }

    public void pushView(GraphicGraph graph, Graphics2D g2) {
        if (this.oldTx == null) {
            this.oldTx = g2.getTransform();
            if (this.autoFit) {
                this.autoFitView(g2);
            } else {
                this.userView(g2);
            }
        } else {
            throw new RuntimeException("DefaultCamera.pushView() / popView() wrongly nested");
        }
        this.checkVisibility(graph);
    }

    public void popView(Graphics2D g2) {
        if (this.oldTx != null) {
            g2.setTransform(this.oldTx);
            this.oldTx = null;
        }
    }

    protected void autoFitView(Graphics2D g2) {
        double padXgu = this.getPaddingXgu() * 2.0;
        double padYgu = this.getPaddingYgu() * 2.0;
        double padXpx = this.getPaddingXpx() * 2.0;
        double padYpx = this.getPaddingYpx() * 2.0;
        double sx = (this.metrics.viewport[2] - padXpx) / (this.metrics.size.data[0] + padXgu);
        double sy = (this.metrics.viewport[3] - padYpx) / (this.metrics.size.data[1] + padYgu);
        double tx = this.metrics.lo.x + this.metrics.size.data[0] / 2.0;
        double ty = this.metrics.lo.y + this.metrics.size.data[1] / 2.0;
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2.translate(this.metrics.viewport[2] / 2.0, this.metrics.viewport[3] / 2.0);
        if (this.rotation != 0.0) {
            g2.rotate(this.rotation / 57.29577951308232);
        }
        g2.scale(sx, -sy);
        g2.translate(-tx, -ty);
        this.Tx = g2.getTransform();
        this.xT = new AffineTransform(this.Tx);
        try {
            this.xT.invert();
        }
        catch (NoninvertibleTransformException e) {
            logger.warning("Cannot inverse gu2px matrix.");
        }
        this.zoom = 1.0;
        this.center.set(tx, ty, 0.0);
        this.metrics.setRatioPx2Gu(sx);
        this.metrics.loVisible.copy(this.metrics.lo);
        this.metrics.hiVisible.copy(this.metrics.hi);
    }

    protected void userView(Graphics2D g2) {
        double padXgu = this.getPaddingXgu() * 2.0;
        double padYgu = this.getPaddingYgu() * 2.0;
        double padXpx = this.getPaddingXpx() * 2.0;
        double padYpx = this.getPaddingYpx() * 2.0;
        double gw = this.gviewport != null ? this.gviewport[2] - this.gviewport[0] : this.metrics.size.data[0];
        double gh = this.gviewport != null ? this.gviewport[3] - this.gviewport[1] : this.metrics.size.data[1];
        double sx = (this.metrics.viewport[2] - padXpx) / ((gw + padXgu) * this.zoom);
        double sy = (this.metrics.viewport[3] - padYpx) / ((gh + padYgu) * this.zoom);
        double tx = this.center.x;
        double ty = this.center.y;
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2.translate(this.metrics.viewport[2] / 2.0, this.metrics.viewport[3] / 2.0);
        if (this.rotation != 0.0) {
            g2.rotate(this.rotation / 57.29577951308232);
        }
        g2.scale(sx, -sy);
        g2.translate(-tx, -ty);
        this.Tx = g2.getTransform();
        this.xT = new AffineTransform(this.Tx);
        try {
            this.xT.invert();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.WARNING, "Cannot inverse gu2px matrix.", e);
        }
        this.metrics.setRatioPx2Gu(sx);
        double w2 = this.metrics.viewport[2] / sx / 2.0;
        double h2 = this.metrics.viewport[3] / sx / 2.0;
        this.metrics.loVisible.set(this.center.x - w2, this.center.y - h2);
        this.metrics.hiVisible.set(this.center.x + w2, this.center.y + h2);
    }

    @Override
    public void setAutoFitView(boolean on) {
        if (this.autoFit && !on) {
            this.zoom = 1.0;
            this.center.set(this.metrics.lo.x + this.metrics.size.data[0] / 2.0, this.metrics.lo.y + this.metrics.size.data[1] / 2.0, 0.0);
        }
        this.autoFit = on;
    }

    public void setZoom(double z) {
        this.zoom = z;
        this.graph.graphChanged = true;
    }

    @Override
    public void setViewRotation(double theta) {
        this.rotation = theta;
        this.graph.graphChanged = true;
    }

    public void setViewport(double viewportX, double viewportY, double viewportWidth, double viewportHeight) {
        this.metrics.setViewport(viewportX, viewportY, viewportWidth, viewportHeight);
    }

    public void setPadding(GraphicGraph graph) {
        this.padding.copy(graph.getStyle().getPadding());
    }

    protected double getPaddingXgu() {
        if (this.padding.units == StyleConstants.Units.GU && this.padding.size() > 0) {
            return this.padding.get(0);
        }
        return 0.0;
    }

    protected double getPaddingYgu() {
        if (this.padding.units == StyleConstants.Units.GU && this.padding.size() > 1) {
            return this.padding.get(1);
        }
        return this.getPaddingXgu();
    }

    protected double getPaddingXpx() {
        if (this.padding.units == StyleConstants.Units.PX && this.padding.size() > 0) {
            return this.padding.get(0);
        }
        return 0.0;
    }

    protected double getPaddingYpx() {
        if (this.padding.units == StyleConstants.Units.PX && this.padding.size() > 1) {
            return this.padding.get(1);
        }
        return this.getPaddingXpx();
    }

    protected boolean isSpriteVisible(GraphicSprite sprite) {
        return this.isSpriteIn(sprite, this.metrics.viewport[0], this.metrics.viewport[1], this.metrics.viewport[0] + this.metrics.viewport[2], this.metrics.viewport[1] + this.metrics.viewport[3]);
    }

    protected boolean isEdgeVisible(GraphicEdge edge) {
        GraphicNode node0 = (GraphicNode)edge.getNode0();
        GraphicNode node1 = (GraphicNode)edge.getNode1();
        if (edge.hidden) {
            return false;
        }
        if (!node1.positionned || !node0.positionned) {
            return false;
        }
        boolean node0Invis = this.nodeInvisible.contains(node0.getId());
        boolean node1Invis = this.nodeInvisible.contains(node1.getId());
        return !node0Invis || !node1Invis;
    }

    protected boolean isNodeIn(GraphicNode node, double X1, double Y1, double X2, double Y2) {
        Values size = node.getStyle().getSize();
        double w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        double h2 = size.size() > 1 ? this.metrics.lengthToPx(size, 1) / 2.0 : w2;
        Point2D.Double src = new Point2D.Double(node.getX(), node.getY());
        boolean vis = true;
        this.Tx.transform(src, src);
        double x1 = src.x - w2;
        double x2 = src.x + w2;
        double y1 = src.y - h2;
        double y2 = src.y + h2;
        if (x2 < X1) {
            vis = false;
        } else if (y2 < Y1) {
            vis = false;
        } else if (x1 > X2) {
            vis = false;
        } else if (y1 > Y2) {
            vis = false;
        }
        return vis;
    }

    protected boolean isSpriteIn(GraphicSprite sprite, double X1, double Y1, double X2, double Y2) {
        if (sprite.isAttachedToNode() && this.nodeInvisible.contains(sprite.getNodeAttachment().getId())) {
            return false;
        }
        if (sprite.isAttachedToEdge() && !this.isEdgeVisible(sprite.getEdgeAttachment())) {
            return false;
        }
        Values size = sprite.getStyle().getSize();
        double w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        double h2 = size.size() > 1 ? this.metrics.lengthToPx(size, 1) / 2.0 : w2;
        Point2D.Double src = this.spritePositionPx(sprite);
        double x1 = src.x - w2;
        double x2 = src.x + w2;
        double y1 = src.y - h2;
        double y2 = src.y + h2;
        if (x2 < X1) {
            return false;
        }
        if (y2 < Y1) {
            return false;
        }
        if (x1 > X2) {
            return false;
        }
        return !(y1 > Y2);
    }

    protected Point2D.Double spritePositionPx(GraphicSprite sprite) {
        Point2D.Double pos = new Point2D.Double();
        return this.getSpritePosition(sprite, pos, StyleConstants.Units.PX);
    }

    protected boolean nodeContains(GraphicElement elt, double x, double y) {
        Values size = elt.getStyle().getSize();
        double w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        double h2 = size.size() > 1 ? this.metrics.lengthToPx(size, 1) / 2.0 : w2;
        Point2D.Double src = new Point2D.Double(elt.getX(), elt.getY());
        Point2D.Double dst = new Point2D.Double();
        this.Tx.transform(src, dst);
        dst.x -= this.metrics.viewport[0];
        dst.y -= this.metrics.viewport[1];
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return !(y > y2);
    }

    protected boolean edgeContains(GraphicElement elt, double x, double y) {
        return false;
    }

    protected boolean spriteContains(GraphicElement elt, double x, double y) {
        Values size = elt.getStyle().getSize();
        double w2 = this.metrics.lengthToPx(size, 0) / 2.0;
        double h2 = size.size() > 1 ? this.metrics.lengthToPx(size, 1) / 2.0 : w2;
        Point2D.Double dst = this.spritePositionPx((GraphicSprite)elt);
        dst.x -= this.metrics.viewport[0];
        dst.y -= this.metrics.viewport[1];
        double x1 = dst.x - w2;
        double x2 = dst.x + w2;
        double y1 = dst.y - h2;
        double y2 = dst.y + h2;
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return !(y > y2);
    }

    protected Point2D.Double getSpritePositionFree(GraphicSprite sprite, Point2D.Double pos, StyleConstants.Units units) {
        if (pos == null) {
            pos = new Point2D.Double();
        }
        if (sprite.getUnits() == units) {
            pos.x = sprite.getX();
            pos.y = sprite.getY();
        } else if (units == StyleConstants.Units.GU && sprite.getUnits() == StyleConstants.Units.PX) {
            pos.x = sprite.getX();
            pos.y = sprite.getY();
            this.xT.transform(pos, pos);
        } else if (units == StyleConstants.Units.PX && sprite.getUnits() == StyleConstants.Units.GU) {
            pos.x = sprite.getX();
            pos.y = sprite.getY();
            this.Tx.transform(pos, pos);
        } else if (units == StyleConstants.Units.GU && sprite.getUnits() == StyleConstants.Units.PERCENTS) {
            pos.x = this.metrics.lo.x + sprite.getX() / 100.0 * this.metrics.graphWidthGU();
            pos.y = this.metrics.lo.y + sprite.getY() / 100.0 * this.metrics.graphHeightGU();
        } else if (units == StyleConstants.Units.PX && sprite.getUnits() == StyleConstants.Units.PERCENTS) {
            pos.x = sprite.getX() / 100.0 * this.metrics.viewport[2];
            pos.y = sprite.getY() / 100.0 * this.metrics.viewport[3];
        } else {
            throw new RuntimeException("Unhandled yet sprite positioning.");
        }
        return pos;
    }

    protected Point2D.Double getSpritePositionNode(GraphicSprite sprite, Point2D.Double pos, StyleConstants.Units units) {
        if (pos == null) {
            pos = new Point2D.Double();
        }
        GraphicNode node = sprite.getNodeAttachment();
        double radius = this.metrics.lengthToGu(sprite.getX(), sprite.getUnits());
        double z = sprite.getZ() * (Math.PI / 180);
        pos.x = node.x + Math.cos(z) * radius;
        pos.y = node.y + Math.sin(z) * radius;
        if (units == StyleConstants.Units.PX) {
            this.Tx.transform(pos, pos);
        }
        return pos;
    }

    protected Point2D.Double getSpritePositionEdge(GraphicSprite sprite, Point2D.Double pos, StyleConstants.Units units) {
        GraphicEdge edge;
        if (pos == null) {
            pos = new Point2D.Double();
        }
        if ((edge = sprite.getEdgeAttachment()).isCurve()) {
            double[] ctrl = edge.getControlPoints();
            Point2 p0 = new Point2(edge.from.getX(), edge.from.getY());
            Point2 p1 = new Point2(ctrl[0], ctrl[1]);
            Point2 p2 = new Point2(ctrl[1], ctrl[2]);
            Point2 p3 = new Point2(edge.to.getX(), edge.to.getY());
            Vector2 perp = CubicCurve.perpendicular(p0, p1, p2, p3, sprite.getX());
            double y = this.metrics.lengthToGu(sprite.getY(), sprite.getUnits());
            perp.normalize();
            perp.scalarMult(y);
            pos.x = CubicCurve.eval(p0.x, p1.x, p2.x, p3.x, sprite.getX()) - perp.data[0];
            pos.y = CubicCurve.eval(p0.y, p1.y, p2.y, p3.y, sprite.getX()) - perp.data[1];
        } else {
            double x = ((GraphicNode)edge.getSourceNode()).x;
            double y = ((GraphicNode)edge.getSourceNode()).y;
            double dx = ((GraphicNode)edge.getTargetNode()).x - x;
            double dy = ((GraphicNode)edge.getTargetNode()).y - y;
            double d = sprite.getX();
            double o = this.metrics.lengthToGu(sprite.getY(), sprite.getUnits());
            d = d > 1.0 ? 1.0 : d;
            d = d < 0.0 ? 0.0 : d;
            x += dx * d;
            y += dy * d;
            d = Math.sqrt(dx * dx + dy * dy);
            pos.x = x += -(dy /= d) * o;
            pos.y = y += (dx /= d) * o;
            if (units == StyleConstants.Units.PX) {
                this.Tx.transform(pos, pos);
            }
        }
        return pos;
    }
}

