/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

import java.util.ArrayList;
import java.util.Iterator;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Value;

public class Values
implements Iterable<Double> {
    public ArrayList<Double> values = new ArrayList();
    public StyleConstants.Units units;

    public Values(StyleConstants.Units units, double ... values) {
        this.units = units;
        for (double value : values) {
            this.values.add(value);
        }
    }

    public Values(Values other) {
        this.values = new ArrayList<Double>(other.values);
        this.units = other.units;
    }

    public Values(Value value) {
        this.values = new ArrayList();
        this.units = value.units;
        this.values.add(value.value);
    }

    public int size() {
        return this.values.size();
    }

    public int getValueCount() {
        return this.values.size();
    }

    public double get(int i) {
        if (i < 0) {
            return this.values.get(0);
        }
        if (i >= this.values.size()) {
            return this.values.get(this.values.size() - 1);
        }
        return this.values.get(i);
    }

    public StyleConstants.Units getUnits() {
        return this.units;
    }

    public boolean equals(Object o) {
        if (o != this) {
            if (!(o instanceof Values)) {
                return false;
            }
            Values other = (Values)o;
            if (other.units != this.units) {
                return false;
            }
            int n = this.values.size();
            if (other.values.size() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (other.values.get(i).equals(this.values.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<Double> iterator() {
        return this.values.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (double value : this.values) {
            builder.append(' ');
            builder.append(value);
        }
        builder.append(" )");
        switch (this.units) {
            case GU: {
                builder.append("gu");
                break;
            }
            case PX: {
                builder.append("px");
                break;
            }
            case PERCENTS: {
                builder.append("%");
                break;
            }
            default: {
                builder.append("wtf (what's the fuck?)");
            }
        }
        return builder.toString();
    }

    public void copy(Values values) {
        this.units = values.units;
        this.values.clear();
        this.values.addAll(values.values);
    }

    public void addValues(double ... values) {
        for (double value : values) {
            this.values.add(value);
        }
    }

    public void insertValue(int i, double value) {
        this.values.add(i, value);
    }

    public void setValue(int i, double value) {
        this.values.set(i, value);
    }

    public void removeValue(int i) {
        this.values.remove(i);
    }

    public void setUnits(StyleConstants.Units units) {
        this.units = units;
    }
}

