/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.NetStreamDecoder;
import org.graphstream.stream.thread.ThreadProxyPipe;

public class DefaultNetStreamDecoder
implements NetStreamDecoder {
    protected boolean debug = true;
    protected ThreadProxyPipe currentStream;
    protected HashMap<String, ThreadProxyPipe> streams = new HashMap();

    @Override
    public synchronized ThreadProxyPipe getStream(String name) {
        ThreadProxyPipe s = this.streams.get(name);
        if (s == null) {
            s = new ThreadProxyPipe();
            this.streams.put(name, s);
        }
        return s;
    }

    @Override
    public synchronized ThreadProxyPipe getDefaultStream() {
        ThreadProxyPipe s = this.streams.get("default");
        if (s == null) {
            s = new ThreadProxyPipe();
            this.streams.put("default", s);
        }
        return s;
    }

    @Override
    public synchronized void register(String name, ThreadProxyPipe stream) throws Exception {
        if (this.streams.containsKey(name)) {
            throw new Exception("name " + name + " already registered");
        }
        this.streams.put(name, stream);
        if (this.debug) {
            this.debug("registered pipe %s", name);
        }
    }

    @Override
    public void decodeMessage(InputStream in) throws IOException {
        int cmd = 0;
        String stream = this.readString(in);
        if (this.debug) {
            this.debug("Stream \"%s\" is addressed in this message.", stream);
        }
        this.currentStream = this.getStream(stream);
        cmd = in.read();
        if (cmd != -1) {
            if (cmd == NetStreamConstants.EVENT_ADD_NODE) {
                this.serve_EVENT_ADD_NODE(in);
            } else if ((cmd & 0xFF) == (NetStreamConstants.EVENT_DEL_NODE & 0xFF)) {
                this.serve_DEL_NODE(in);
            } else if (cmd == NetStreamConstants.EVENT_ADD_EDGE) {
                this.serve_EVENT_ADD_EDGE(in);
            } else if (NetStreamConstants.EVENT_DEL_EDGE == cmd) {
                this.serve_EVENT_DEL_EDGE(in);
            } else if (cmd == NetStreamConstants.EVENT_STEP) {
                this.serve_EVENT_STEP(in);
            } else if (cmd == NetStreamConstants.EVENT_CLEARED) {
                this.serve_EVENT_CLEARED(in);
            } else if (cmd == NetStreamConstants.EVENT_ADD_GRAPH_ATTR) {
                this.serve_EVENT_ADD_GRAPH_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_CHG_GRAPH_ATTR) {
                this.serve_EVENT_CHG_GRAPH_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_DEL_GRAPH_ATTR) {
                this.serve_EVENT_DEL_GRAPH_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_ADD_NODE_ATTR) {
                this.serve_EVENT_ADD_NODE_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_CHG_NODE_ATTR) {
                this.serve_EVENT_CHG_NODE_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_DEL_NODE_ATTR) {
                this.serve_EVENT_DEL_NODE_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_ADD_EDGE_ATTR) {
                this.serve_EVENT_ADD_EDGE_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_CHG_EDGE_ATTR) {
                this.serve_EVENT_CHG_EDGE_ATTR(in);
            } else if (cmd == NetStreamConstants.EVENT_DEL_EDGE_ATTR) {
                this.serve_EVENT_DEL_EDGE_ATTR(in);
            } else {
                if (cmd == NetStreamConstants.EVENT_END) {
                    this.debug("NetStreamReceiver : Client properly ended the connection.", new Object[0]);
                    return;
                }
                this.debug("NetStreamReceiver: Don't know this command: " + cmd, new Object[0]);
                return;
            }
            cmd = in.read();
        }
    }

    protected void serve_EVENT_DEL_EDGE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received DEL_EDGE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String edgeId = this.readString(in);
        String attrId = this.readString(in);
        this.currentStream.edgeAttributeRemoved(sourceId, timeId, edgeId, attrId);
    }

    protected void serve_EVENT_CHG_EDGE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received CHG_EDGE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String edgeId = this.readString(in);
        String attrId = this.readString(in);
        int oldValueType = this.readType(in);
        Object oldValue = this.readValue(in, oldValueType);
        int newValueType = this.readType(in);
        Object newValue = this.readValue(in, newValueType);
        this.currentStream.edgeAttributeChanged(sourceId, timeId, edgeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_EDGE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received ADD_EDGE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String edgeId = this.readString(in);
        String attrId = this.readString(in);
        Object value = this.readValue(in, this.readType(in));
        this.currentStream.edgeAttributeAdded(sourceId, timeId, edgeId, attrId, value);
    }

    protected void serve_EVENT_DEL_NODE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received DEL_NODE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String nodeId = this.readString(in);
        String attrId = this.readString(in);
        this.currentStream.nodeAttributeRemoved(sourceId, timeId, nodeId, attrId);
    }

    protected void serve_EVENT_CHG_NODE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_CHG_NODE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String nodeId = this.readString(in);
        String attrId = this.readString(in);
        int oldValueType = this.readType(in);
        Object oldValue = this.readValue(in, oldValueType);
        int newValueType = this.readType(in);
        Object newValue = this.readValue(in, newValueType);
        this.currentStream.nodeAttributeChanged(sourceId, timeId, nodeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_NODE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_ADD_NODE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String nodeId = this.readString(in);
        String attrId = this.readString(in);
        Object value = this.readValue(in, this.readType(in));
        this.currentStream.nodeAttributeAdded(sourceId, timeId, nodeId, attrId, value);
    }

    protected void serve_EVENT_DEL_GRAPH_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_DEL_GRAPH_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String attrId = this.readString(in);
        this.currentStream.graphAttributeRemoved(sourceId, timeId, attrId);
    }

    protected void serve_EVENT_CHG_GRAPH_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_CHG_GRAPH_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String attrId = this.readString(in);
        int oldValueType = this.readType(in);
        Object oldValue = this.readValue(in, oldValueType);
        int newValueType = this.readType(in);
        Object newValue = this.readValue(in, newValueType);
        this.currentStream.graphAttributeChanged(sourceId, timeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_GRAPH_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_ADD_GRAPH_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String attrId = this.readString(in);
        Object value = this.readValue(in, this.readType(in));
        if (this.debug) {
            this.debug("NetStreamServer | EVENT_ADD_GRAPH_ATTR | %s=%s", attrId, value.toString());
        }
        this.currentStream.graphAttributeAdded(sourceId, timeId, attrId, value);
    }

    protected void serve_EVENT_CLEARED(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_CLEARED command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        this.currentStream.graphCleared(sourceId, timeId);
    }

    protected void serve_EVENT_STEP(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_STEP command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        double time = this.readDouble(in);
        this.currentStream.stepBegins(sourceId, timeId, time);
    }

    protected void serve_EVENT_DEL_EDGE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_DEL_EDGE command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String edgeId = this.readString(in);
        this.currentStream.edgeRemoved(sourceId, timeId, edgeId);
    }

    protected void serve_EVENT_ADD_EDGE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received ADD_EDGE command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String edgeId = this.readString(in);
        String from = this.readString(in);
        String to = this.readString(in);
        boolean directed = this.readBoolean(in);
        this.currentStream.edgeAdded(sourceId, timeId, edgeId, from, to, directed);
    }

    protected void serve_DEL_NODE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received DEL_NODE command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String nodeId = this.readString(in);
        this.currentStream.nodeRemoved(sourceId, timeId, nodeId);
    }

    protected void serve_EVENT_ADD_NODE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_ADD_NODE command", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readUnsignedVarint(in);
        String nodeId = this.readString(in);
        this.currentStream.nodeAdded(sourceId, timeId, nodeId);
    }

    protected int readType(InputStream in) {
        try {
            int data = 0;
            data = in.read();
            if (data == -1) {
                this.debug("readType : could not read type", new Object[0]);
                return 0;
            }
            if (this.debug) {
                this.debug("NetStreamServer: type " + data, new Object[0]);
            }
            return data;
        }
        catch (IOException e) {
            this.debug("readType: could not read type", new Object[0]);
            e.printStackTrace();
            return 0;
        }
    }

    protected Object readValue(InputStream in, int valueType) {
        if (NetStreamConstants.TYPE_BOOLEAN == valueType) {
            return this.readBoolean(in);
        }
        if (NetStreamConstants.TYPE_BOOLEAN_ARRAY == valueType) {
            return this.readBooleanArray(in);
        }
        if (NetStreamConstants.TYPE_BYTE == valueType) {
            return this.readByte(in);
        }
        if (NetStreamConstants.TYPE_BYTE_ARRAY == valueType) {
            return this.readByteArray(in);
        }
        if (NetStreamConstants.TYPE_SHORT == valueType) {
            return this.readShort(in);
        }
        if (NetStreamConstants.TYPE_SHORT_ARRAY == valueType) {
            return this.readShortArray(in);
        }
        if (NetStreamConstants.TYPE_INT == valueType) {
            return this.readInt(in);
        }
        if (NetStreamConstants.TYPE_INT_ARRAY == valueType) {
            return this.readIntArray(in);
        }
        if (NetStreamConstants.TYPE_LONG == valueType) {
            return this.readLong(in);
        }
        if (NetStreamConstants.TYPE_LONG_ARRAY == valueType) {
            return this.readLongArray(in);
        }
        if (NetStreamConstants.TYPE_FLOAT == valueType) {
            return this.readFloat(in);
        }
        if (NetStreamConstants.TYPE_FLOAT_ARRAY == valueType) {
            return this.readFloatArray(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE == valueType) {
            return this.readDouble(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE_ARRAY == valueType) {
            return this.readDoubleArray(in);
        }
        if (NetStreamConstants.TYPE_STRING == valueType) {
            return this.readString(in);
        }
        if (NetStreamConstants.TYPE_ARRAY == valueType) {
            return this.readArray(in);
        }
        return null;
    }

    protected Object[] readArray(InputStream in) {
        int len = (int)this.readUnsignedVarint(in);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readValue(in, this.readType(in));
        }
        return array;
    }

    protected String readString(InputStream in) {
        try {
            int len = (int)this.readUnsignedVarint(in);
            byte[] data = new byte[len];
            if (in.read(data, 0, len) != len) {
                return null;
            }
            String s = new String(data, Charset.forName("UTF-8"));
            return s;
        }
        catch (IOException e) {
            this.debug("readString: could not read string", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Boolean readBoolean(InputStream in) {
        int data = 0;
        try {
            data = in.read();
        }
        catch (IOException e) {
            this.debug("readByte: could not read", new Object[0]);
            e.printStackTrace();
        }
        return data != 0;
    }

    protected Byte readByte(InputStream in) {
        byte data = 0;
        try {
            data = (byte)in.read();
        }
        catch (IOException e) {
            this.debug("readByte: could not read", new Object[0]);
            e.printStackTrace();
        }
        return data;
    }

    protected long readUnsignedVarint(InputStream in) {
        try {
            int size = 0;
            long[] data = new long[9];
            do {
                data[size] = in.read();
            } while ((data[++size - 1] & 0x80L) == 128L);
            long number = 0L;
            for (int i = 0; i < size; ++i) {
                number ^= (data[i] & 0x7FL) << (int)((long)i * 7L);
            }
            return number;
        }
        catch (IOException e) {
            this.debug("readUnsignedVarintFromInteger: could not read", new Object[0]);
            e.printStackTrace();
            return 0L;
        }
    }

    protected long readVarint(InputStream in) {
        long number = this.readUnsignedVarint(in);
        return (number & 1L) == 0L ? number >> 1 : -(number >> 1);
    }

    protected Short readShort(InputStream in) {
        return (short)this.readVarint(in);
    }

    protected Integer readInt(InputStream in) {
        return (int)this.readVarint(in);
    }

    protected Long readLong(InputStream in) {
        return this.readVarint(in);
    }

    protected Float readFloat(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readFloat: could not read", new Object[0]);
                return Float.valueOf(0.0f);
            }
        }
        catch (IOException e) {
            this.debug("readFloat: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(data);
        bb.flip();
        return Float.valueOf(bb.getFloat());
    }

    protected Double readDouble(InputStream in) {
        byte[] data = new byte[8];
        try {
            if (in.read(data, 0, 8) != 8) {
                this.debug("readDouble: could not read", new Object[0]);
                return 0.0;
            }
        }
        catch (IOException e) {
            this.debug("readDouble: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(data);
        bb.flip();
        return bb.getDouble();
    }

    protected Integer[] readIntArray(InputStream in) {
        int len = (int)this.readUnsignedVarint(in);
        Integer[] res = new Integer[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (int)this.readVarint(in);
        }
        return res;
    }

    protected Boolean[] readBooleanArray(InputStream in) {
        byte[] data = null;
        try {
            int len = (int)this.readUnsignedVarint(in);
            data = new byte[len];
            if (in.read(data, 0, len) != len) {
                this.debug("readBooleanArray: could not read array", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(len);
            bb.put(data);
            bb.flip();
            Boolean[] res = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                byte b = bb.get();
                res[i] = b != 0;
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readBooleanArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Byte[] readByteArray(InputStream in) {
        byte[] data = null;
        try {
            int len = (int)this.readUnsignedVarint(in);
            data = new byte[len];
            if (in.read(data, 0, len) != len) {
                this.debug("readByteArray: could not read array", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(len);
            bb.put(data);
            bb.flip();
            Byte[] res = new Byte[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.get();
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readBooleanArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Double[] readDoubleArray(InputStream in) {
        byte[] data = null;
        try {
            int len = (int)this.readUnsignedVarint(in);
            data = new byte[len * 8];
            if (in.read(data, 0, len * 8) != len * 8) {
                this.debug("readDoubleArray: could not read array", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(8 * len);
            bb.put(data);
            bb.flip();
            Double[] res = new Double[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.getDouble();
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readDoubleArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Float[] readFloatArray(InputStream in) {
        byte[] data = null;
        try {
            int len = (int)this.readUnsignedVarint(in);
            data = new byte[len * 4];
            if (in.read(data, 0, len * 4) != len * 4) {
                this.debug("readFloatArray: could not read array", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4 * len);
            bb.put(data);
            bb.flip();
            Float[] res = new Float[len];
            for (int i = 0; i < len; ++i) {
                res[i] = Float.valueOf(bb.getFloat());
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readFloatArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Long[] readLongArray(InputStream in) {
        int len = (int)this.readUnsignedVarint(in);
        Long[] res = new Long[len];
        for (int i = 0; i < len; ++i) {
            res[i] = this.readVarint(in);
        }
        return res;
    }

    protected Short[] readShortArray(InputStream in) {
        int len = (int)this.readUnsignedVarint(in);
        Short[] res = new Short[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (short)this.readVarint(in);
        }
        return res;
    }

    protected void debug(String message, Object ... data) {
        System.err.printf("[//NetStreamDecoder | ", new Object[0]);
        System.err.printf(message, data);
        System.err.printf("]%n", new Object[0]);
    }

    @Override
    public void setDebugOn(boolean on) {
        this.debug = on;
    }
}

