/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class DepthFirstIterator<T extends Node>
implements Iterator<T> {
    boolean directed;
    Graph graph;
    Node[] parent;
    Iterator<Edge>[] iterator;
    int[] depth;
    Node next;
    int maxDepth;

    public DepthFirstIterator(Node startNode, boolean directed) {
        this.directed = directed;
        this.graph = startNode.getGraph();
        int n = this.graph.getNodeCount();
        this.parent = new Node[n];
        this.iterator = new Iterator[n];
        this.depth = new int[n];
        int s = startNode.getIndex();
        for (int i = 0; i < n; ++i) {
            this.depth[i] = i == s ? 0 : -1;
        }
        this.next = startNode;
    }

    protected void gotoNext() {
        while (this.next != null) {
            int i = this.next.getIndex();
            while (this.iterator[i].hasNext()) {
                Object neighbor = this.iterator[i].next().getOpposite(this.next);
                int j = neighbor.getIndex();
                if (this.iterator[j] != null) continue;
                this.parent[j] = this.next;
                this.iterator[j] = this.directed ? neighbor.getLeavingEdgeIterator() : neighbor.getEnteringEdgeIterator();
                this.depth[j] = this.depth[i] + 1;
                if (this.depth[j] > this.maxDepth) {
                    this.maxDepth = this.depth[j];
                }
                this.next = neighbor;
                return;
            }
            this.next = this.parent[i];
        }
    }

    public DepthFirstIterator(Node startNode) {
        this(startNode, true);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.iterator[this.next.getIndex()] = this.directed ? this.next.getLeavingEdgeIterator() : this.next.getEnteringEdgeIterator();
        Node previous = this.next;
        this.gotoNext();
        return (T)previous;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support remove");
    }

    public int getDepthOf(Node node) {
        return this.depth[node.getIndex()];
    }

    public int getDepthMax() {
        return this.maxDepth;
    }

    public boolean tabu(Node node) {
        return this.depth[node.getIndex()] != -1;
    }

    public boolean isDirected() {
        return this.directed;
    }
}

