/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodProperty
implements JavaProperty {
    private final String name;
    private final JavaMethod readMethod;
    private final JavaMethod writeMethod;
    private final Class<?> type;
    private final As3Type as3Type;
    private final boolean externalizedProperty;

    public JavaMethodProperty(JavaTypeFactory provider, String name, JavaMethod readMethod, JavaMethod writeMethod) {
        if (name == null || readMethod == null && writeMethod == null) {
            throw new NullPointerException("Invalid parameters");
        }
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.type = readMethod != null ? ((Method)readMethod.getMember()).getReturnType() : ((Method)writeMethod.getMember()).getParameterTypes()[0];
        this.as3Type = provider.getAs3Type(this.type);
        this.externalizedProperty = readMethod != null && ((Method)readMethod.getMember()).isAnnotationPresent(ExternalizedProperty.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type[] getGenericTypes() {
        Type type;
        Type type2 = type = this.readMethod != null ? ((Method)this.readMethod.getMember()).getGenericReturnType() : ((Method)this.writeMethod.getMember()).getGenericParameterTypes()[0];
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    @Override
    public boolean isReadable() {
        return this.readMethod != null;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethod != null;
    }

    @Override
    public boolean isExternalizedProperty() {
        return this.externalizedProperty;
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum() || Enum.class.getName().equals(this.type.getName());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.readMethod != null && ((Method)this.readMethod.getMember()).isAnnotationPresent(annotationClass) || this.writeMethod != null && ((Method)this.writeMethod.getMember()).isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        if (this.readMethod != null && (annotation = (T)((Method)this.readMethod.getMember()).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        if (this.writeMethod != null && (annotation = (T)((Method)this.writeMethod.getMember()).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        ArrayList<Annotation> annos = new ArrayList<Annotation>();
        if (this.readMethod != null) {
            annos.addAll(Arrays.asList(((Method)this.readMethod.getMember()).getDeclaredAnnotations()));
        }
        if (this.writeMethod != null) {
            annos.addAll(Arrays.asList(((Method)this.writeMethod.getMember()).getDeclaredAnnotations()));
        }
        return annos.toArray(new Annotation[0]);
    }

    @Override
    public boolean isReadOverride() {
        return this.readMethod != null && this.readMethod.isOverride();
    }

    @Override
    public boolean isWriteOverride() {
        return this.writeMethod != null && this.writeMethod.isOverride();
    }

    @Override
    public JavaMethod getReadMethod() {
        return this.readMethod;
    }

    @Override
    public JavaMethod getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public As3Type getAs3Type() {
        return this.as3Type;
    }

    @Override
    public int compareTo(JavaProperty o) {
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavaMethodProperty) {
            return ((JavaMethodProperty)obj).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

