/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaMember;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.service.annotations.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod
extends JavaMember<Method> {
    private final String name;
    private final boolean override;
    private final MethodType type;
    private final Class<?>[] parameterTypes;
    private final As3Type[] as3ParameterTypes;
    private final String[] as3ParameterNames;

    public JavaMethod(Method method, MethodType type) {
        this(method, type, null);
    }

    public JavaMethod(Method method, MethodType type, JavaTypeFactory provider) {
        super(method);
        this.name = method.getName();
        boolean override = false;
        for (Class<?> superclass = method.getDeclaringClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            try {
                Method superMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                if (superMethod.getReturnType() != method.getReturnType()) continue;
                override = true;
                break;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        this.override = override;
        this.type = type;
        if (type == MethodType.OTHER && provider != null) {
            this.parameterTypes = method.getParameterTypes();
            this.as3ParameterTypes = new As3Type[this.parameterTypes.length];
            this.as3ParameterNames = new String[this.parameterTypes.length];
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.as3ParameterNames[i] = this.getParamName(method, i);
                this.as3ParameterTypes[i] = Map.class.isAssignableFrom(this.parameterTypes[i]) ? As3Type.OBJECT : provider.getAs3Type(this.parameterTypes[i]);
            }
        } else {
            this.parameterTypes = null;
            this.as3ParameterTypes = null;
            this.as3ParameterNames = null;
        }
    }

    private String getParamName(Method method, int paramIndex) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations != null && annotations.length > paramIndex && annotations[paramIndex] != null) {
            for (Annotation annotation : annotations[paramIndex]) {
                if (!annotation.annotationType().equals(Param.class)) continue;
                return ((Param)annotation).value();
            }
        }
        return "arg" + paramIndex;
    }

    public boolean isOverride() {
        return this.override;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.name();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public As3Type[] getAs3ParameterTypes() {
        return this.as3ParameterTypes;
    }

    public String[] getAs3ParameterNames() {
        return this.as3ParameterNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        GETTER,
        SETTER,
        OTHER;

    }
}

