/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.generator.Input;
import org.granite.generator.Listener;
import org.granite.generator.TemplateUri;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.JavaAs3GroovyConfiguration;
import org.granite.generator.as3.JavaAs3Input;
import org.granite.generator.as3.JavaAs3Output;
import org.granite.generator.as3.PackageTranslator;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaBean;
import org.granite.generator.as3.reflect.JavaEnum;
import org.granite.generator.as3.reflect.JavaFieldProperty;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaRemoteDestination;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.generator.exception.TemplateException;
import org.granite.generator.exception.TemplateUriException;
import org.granite.generator.gsp.AbstractGroovyTransformer;
import org.granite.generator.gsp.GroovyTemplate;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAs3GroovyTransformer
extends AbstractGroovyTransformer<JavaAs3Input, JavaAs3Output, JavaAs3GroovyConfiguration>
implements JavaTypeFactory {
    protected final Map<Class<?>, JavaType> javaTypes = new HashMap();
    protected final Map<Class<?>, JavaImport> javaImports = new HashMap();

    public JavaAs3GroovyTransformer() {
    }

    public JavaAs3GroovyTransformer(JavaAs3GroovyConfiguration config, Listener listener) {
        super(config, listener);
    }

    @Override
    public boolean accept(Input<?> input) {
        return input instanceof JavaAs3Input;
    }

    protected JavaAs3Output[] getOutputs(JavaAs3Input input) throws IOException, TemplateUriException {
        JavaType javaType = this.getJavaType((Class<?>)input.getType());
        input.setJavaType(javaType);
        TemplateUri[] templateUris = this.getTemplateUris(javaType);
        boolean hasBaseTemplate = templateUris.length > 1;
        JavaAs3Output[] outputs = new JavaAs3Output[templateUris.length];
        for (int i = 0; i < templateUris.length; ++i) {
            GroovyTemplate template = this.getTemplate(templateUris[i]);
            File dir = this.getOutputDir(input, template);
            File file = this.getOutputFile(input, template, dir);
            boolean outdated = this.isOutdated(input, template, file, hasBaseTemplate);
            String status = this.getOutputStatus(input, template, file, hasBaseTemplate);
            outputs[i] = new JavaAs3Output(javaType, template, dir, file, outdated, status);
        }
        return outputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generate(JavaAs3Input input, JavaAs3Output output) throws IOException, TemplateException {
        Map<String, Object> bindings = this.getBindings(input, output);
        PublicByteArrayOutputStream pbaos = new PublicByteArrayOutputStream(8192);
        output.getTemplate().execute(bindings, new PrintWriter(new OutputStreamWriter(pbaos)));
        OutputStream stream = null;
        try {
            stream = output.openStream();
            stream.write(pbaos.getBytes(), 0, pbaos.size());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected Map<String, Object> getBindings(JavaAs3Input input, JavaAs3Output output) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("gVersion", "2.1.0");
        bindings.put("jClass", input.getJavaType());
        return bindings;
    }

    protected TemplateUri[] getTemplateUris(JavaType javaType) {
        return ((JavaAs3GroovyConfiguration)this.getConfig()).getTemplateUris(this.getKind(javaType.getType()), javaType.getClass());
    }

    protected File getOutputDir(JavaAs3Input input, GroovyTemplate template) {
        return template.isBase() ? ((JavaAs3GroovyConfiguration)this.getConfig()).getBaseOutputDir(input) : ((JavaAs3GroovyConfiguration)this.getConfig()).getOutputDir(input);
    }

    protected File getOutputFile(JavaAs3Input input, GroovyTemplate template, File outputDir) {
        As3Type as3Type = input.getJavaType().getAs3Type();
        StringBuilder sb = new StringBuilder().append(outputDir.getAbsolutePath()).append(File.separatorChar).append(as3Type.getQualifiedName().replace('.', File.separatorChar)).append(this.getOutputFileSuffix(input, template)).append(".as");
        return new File(sb.toString());
    }

    protected String getOutputFileSuffix(JavaAs3Input input, GroovyTemplate template) {
        return template.isBase() ? "Base" : "";
    }

    protected boolean isOutdated(JavaAs3Input input, GroovyTemplate template, File outputFile, boolean hasBaseTemplate) {
        if (!outputFile.exists()) {
            return true;
        }
        if (outputFile.lastModified() > System.currentTimeMillis()) {
            this.getListener().warn(outputFile.getAbsolutePath() + " has a last modified time in the future: " + DateFormat.getInstance().format(new Date(outputFile.lastModified())));
        }
        if (!template.isBase() && hasBaseTemplate) {
            return false;
        }
        return input.getFile().lastModified() > outputFile.lastModified();
    }

    protected String getOutputStatus(JavaAs3Input input, GroovyTemplate template, File outputFile, boolean hasBaseTemplate) {
        if (!outputFile.exists()) {
            return "output file does not exist";
        }
        if (!template.isBase() && hasBaseTemplate) {
            return "output file already exists and must not be overwritten";
        }
        if (input.getFile().lastModified() > outputFile.lastModified()) {
            return "output file is outdated";
        }
        return "output file is up-to-date";
    }

    @Override
    public As3Type getAs3Type(Class<?> clazz) {
        As3Type as3Type = ((JavaAs3GroovyConfiguration)this.getConfig()).getAs3TypeFactory().getAs3Type(clazz);
        if (((JavaAs3GroovyConfiguration)this.getConfig()).getTranslators().isEmpty() || clazz.getPackage() == null) {
            return as3Type;
        }
        PackageTranslator translator = null;
        String packageName = clazz.getPackage().getName();
        int weight = 0;
        for (PackageTranslator t : ((JavaAs3GroovyConfiguration)this.getConfig()).getTranslators()) {
            int w = t.match(packageName);
            if (w <= weight) continue;
            weight = w;
            translator = t;
        }
        if (translator != null) {
            as3Type = new As3Type(translator.translate(packageName), as3Type.getName());
        }
        return as3Type;
    }

    @Override
    public JavaImport getJavaImport(Class<?> clazz) {
        JavaImport javaImport = this.javaImports.get(clazz);
        if (javaImport == null) {
            URL url = ClassUtil.findResource(clazz);
            javaImport = new JavaImport(this, clazz, url);
            this.javaImports.put(clazz, javaImport);
        }
        return javaImport;
    }

    @Override
    public JavaType getJavaType(Class<?> clazz) {
        JavaType javaType = this.javaTypes.get(clazz);
        if (javaType == null && ((JavaAs3GroovyConfiguration)this.getConfig()).isGenerated(clazz)) {
            URL url = ClassUtil.findResource(clazz);
            JavaType.Kind kind = this.getKind(clazz);
            switch (kind) {
                case ENUM: {
                    javaType = new JavaEnum(this, clazz, url);
                    break;
                }
                case REMOTE_DESTINATION: {
                    if (((JavaAs3GroovyConfiguration)this.getConfig()).getRemoteDestinationFactory() != null) {
                        javaType = ((JavaAs3GroovyConfiguration)this.getConfig()).getRemoteDestinationFactory().newRemoteDestination(this, clazz, url);
                        break;
                    }
                    throw new RuntimeException("Remote destination could not be handled for " + clazz);
                }
                case INTERFACE: {
                    javaType = new JavaInterface(this, clazz, url);
                    break;
                }
                case ENTITY: {
                    javaType = ((JavaAs3GroovyConfiguration)this.getConfig()).getEntityFactory().newEntity(this, clazz, url);
                    break;
                }
                case BEAN: {
                    javaType = new JavaBean(this, clazz, url);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown class kind: " + (Object)((Object)kind));
                }
            }
            this.javaTypes.put(clazz, javaType);
        }
        return javaType;
    }

    @Override
    public JavaType.Kind getKind(Class<?> clazz) {
        if (clazz.isEnum()) {
            return JavaType.Kind.ENUM;
        }
        if (((JavaAs3GroovyConfiguration)this.getConfig()).getRemoteDestinationFactory() != null && ((JavaAs3GroovyConfiguration)this.getConfig()).getRemoteDestinationFactory().isRemoteDestination(clazz)) {
            return JavaType.Kind.REMOTE_DESTINATION;
        }
        if (clazz.isInterface()) {
            return JavaType.Kind.INTERFACE;
        }
        if (((JavaAs3GroovyConfiguration)this.getConfig()).getEntityFactory().isEntity(clazz)) {
            return JavaType.Kind.ENTITY;
        }
        return JavaType.Kind.BEAN;
    }

    protected JavaAbstractType.GenerationType getGenerationType(Class<?> clazz) {
        return this.getGenerationType(this.getKind(clazz), clazz);
    }

    @Override
    public JavaAbstractType.GenerationType getGenerationType(JavaType.Kind kind, Class<?> clazz) {
        if (!((JavaAs3GroovyConfiguration)this.getConfig()).isGenerated(clazz)) {
            return JavaAbstractType.GenerationType.NOT_GENERATED;
        }
        TemplateUri[] uris = ((JavaAs3GroovyConfiguration)this.getConfig()).getTemplateUris(kind, clazz);
        if (uris == null || uris.length == 0) {
            return JavaAbstractType.GenerationType.NOT_GENERATED;
        }
        return uris.length == 1 ? JavaAbstractType.GenerationType.GENERATED_SINGLE : JavaAbstractType.GenerationType.GENERATED_WITH_BASE;
    }

    @Override
    public List<JavaInterface> getJavaTypeInterfaces(Class<?> clazz) {
        ArrayList<JavaInterface> interfazes = new ArrayList<JavaInterface>();
        for (Class<?> interfaze : clazz.getInterfaces()) {
            if (!((JavaAs3GroovyConfiguration)this.getConfig()).isGenerated(interfaze)) continue;
            JavaType javaType = this.getJavaType(interfaze);
            if (javaType instanceof JavaRemoteDestination) {
                javaType = ((JavaRemoteDestination)javaType).convertToJavaInterface();
            }
            interfazes.add((JavaInterface)javaType);
        }
        return interfazes;
    }

    @Override
    public JavaType getJavaTypeSuperclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && ((JavaAs3GroovyConfiguration)this.getConfig()).isGenerated(superclass)) {
            return this.getJavaType(superclass);
        }
        return null;
    }

    @Override
    public boolean isId(JavaFieldProperty fieldProperty) {
        return ((JavaAs3GroovyConfiguration)this.getConfig()).getEntityFactory().isId(fieldProperty);
    }

    @Override
    public boolean isUid(JavaProperty property) {
        return ((JavaAs3GroovyConfiguration)this.getConfig()).getUid() == null ? "uid".equals(property.getName()) : ((JavaAs3GroovyConfiguration)this.getConfig()).getUid().equals(property.getName());
    }

    @Override
    public boolean isVersion(JavaProperty property) {
        return ((JavaAs3GroovyConfiguration)this.getConfig()).getEntityFactory().isVersion(property);
    }

    static class PublicByteArrayOutputStream
    extends ByteArrayOutputStream {
        public PublicByteArrayOutputStream() {
        }

        public PublicByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getBytes() {
            return this.buf;
        }
    }
}

