/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.util.ClassUtil;
import org.granite.util.URIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaAbstractType
implements JavaType {
    protected final JavaTypeFactory provider;
    protected final Class<?> type;
    protected final URL url;
    protected final As3Type as3Type;
    protected final JavaType.Kind kind;
    protected final GenerationType generationType;
    private long lastModified = Long.MIN_VALUE;

    protected JavaAbstractType(JavaTypeFactory provider, Class<?> type, URL url) {
        if (provider == null || type == null) {
            throw new IllegalArgumentException("Parameter provider and type cannot be null");
        }
        this.provider = provider;
        this.type = type;
        this.url = url;
        this.as3Type = provider.getAs3Type(type);
        this.kind = provider.getKind(type);
        this.generationType = provider.getGenerationType(this.kind, type);
    }

    protected JavaTypeFactory getProvider() {
        return this.provider;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        if (this.type.isMemberClass()) {
            return String.valueOf(this.type.getEnclosingClass().getSimpleName()) + '$' + this.type.getSimpleName();
        }
        return this.type.getSimpleName();
    }

    @Override
    public Package getPackage() {
        return this.type.getPackage();
    }

    @Override
    public String getPackageName() {
        return this.type.getPackage() != null ? this.type.getPackage().getName() : "";
    }

    public String getQualifiedName() {
        if (this.type.getPackage() == null) {
            return this.getName();
        }
        return this.getPackageName() + '.' + this.getName();
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isBean() {
        return this.kind == JavaType.Kind.BEAN;
    }

    @Override
    public boolean isEntity() {
        return this.kind == JavaType.Kind.ENTITY;
    }

    @Override
    public boolean isEnum() {
        return this.kind == JavaType.Kind.ENUM;
    }

    @Override
    public boolean isInterface() {
        return this.kind == JavaType.Kind.INTERFACE;
    }

    @Override
    public boolean isRemoteDestination() {
        return this.kind == JavaType.Kind.REMOTE_DESTINATION;
    }

    @Override
    public boolean isGenerated() {
        return this.generationType != GenerationType.NOT_GENERATED;
    }

    @Override
    public boolean isWithBase() {
        return this.generationType == GenerationType.GENERATED_WITH_BASE;
    }

    @Override
    public GenerationType getGenerationType() {
        return this.generationType;
    }

    @Override
    public JavaType.Kind getKind() {
        return this.kind;
    }

    @Override
    public long getLastModified() {
        if (this.lastModified == Long.MIN_VALUE) {
            try {
                this.lastModified = URIUtil.lastModified((URL)this.url);
            }
            catch (IOException e) {
                this.lastModified = -1L;
            }
        }
        return this.lastModified;
    }

    @Override
    public As3Type getAs3Type() {
        return this.as3Type;
    }

    protected <T extends Collection<?>> T removeNull(T coll) {
        coll.remove(null);
        return coll;
    }

    protected PropertyDescriptor[] getPropertyDescriptors(Class<?> type) {
        PropertyDescriptor[] propertyDescriptors = ClassUtil.getProperties(type);
        return propertyDescriptors != null ? propertyDescriptors : new PropertyDescriptor[]{};
    }

    protected List<JavaProperty> getSortedUnmodifiableList(Collection<JavaProperty> coll) {
        List<Object> list = coll instanceof List ? (List<Object>)coll : new ArrayList<JavaProperty>(coll);
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenerationType {
        NOT_GENERATED,
        GENERATED_SINGLE,
        GENERATED_WITH_BASE;

    }
}

