/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3;

import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.util.ClassUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAs3TypeFactory
implements As3TypeFactory {
    private final Map<Class<?>, As3Type> java2As3Type = new HashMap();

    public DefaultAs3TypeFactory() {
        this.java2As3Type.put(Double.class, As3Type.NUMBER);
        this.java2As3Type.put(Double.TYPE, As3Type.NUMBER);
        this.java2As3Type.put(Float.class, As3Type.NUMBER);
        this.java2As3Type.put(Float.TYPE, As3Type.NUMBER);
        this.java2As3Type.put(Long.class, As3Type.NUMBER);
        this.java2As3Type.put(Long.TYPE, As3Type.NUMBER);
        this.java2As3Type.put(Integer.class, As3Type.NUMBER);
        this.java2As3Type.put(Integer.TYPE, As3Type.INT);
        this.java2As3Type.put(Short.class, As3Type.NUMBER);
        this.java2As3Type.put(Short.TYPE, As3Type.INT);
        this.java2As3Type.put(Byte.class, As3Type.NUMBER);
        this.java2As3Type.put(Byte.TYPE, As3Type.INT);
        this.java2As3Type.put(Boolean.class, As3Type.BOOLEAN);
        this.java2As3Type.put(Boolean.TYPE, As3Type.BOOLEAN);
        this.java2As3Type.put(String.class, As3Type.STRING);
        this.java2As3Type.put(Character.class, As3Type.STRING);
        this.java2As3Type.put(Character.TYPE, As3Type.STRING);
        this.java2As3Type.put(Locale.class, As3Type.STRING);
        this.java2As3Type.put(URL.class, As3Type.STRING);
        this.java2As3Type.put(URI.class, As3Type.STRING);
        this.java2As3Type.put(Object.class, As3Type.OBJECT);
    }

    @Override
    public As3Type getAs3Type(Class<?> jType) {
        As3Type as3Type = this.getFromCache(jType);
        if (as3Type == null) {
            Class<?> componentType;
            as3Type = Date.class.isAssignableFrom(jType) || Calendar.class.isAssignableFrom(jType) ? As3Type.DATE : (Number.class.isAssignableFrom(jType) ? As3Type.NUMBER : (Document.class.isAssignableFrom(jType) ? As3Type.XML : (jType.isArray() ? (Byte.class.equals(componentType = jType.getComponentType()) || Byte.TYPE.equals(componentType) ? As3Type.BYTE_ARRAY : (Character.class.equals(componentType) || Character.TYPE.equals(componentType) ? As3Type.STRING : As3Type.ARRAY)) : (Collection.class.isAssignableFrom(jType) ? As3Type.ARRAY_COLLECTION : (Map.class.isAssignableFrom(jType) ? As3Type.IMAP : (jType.getName().equals("com.google.appengine.api.datastore.Key") ? As3Type.STRING : this.createAs3Type(jType)))))));
            this.putInCache(jType, as3Type);
        }
        return as3Type;
    }

    protected As3Type createAs3Type(Class<?> jType) {
        String name = jType.getSimpleName();
        if (jType.isMemberClass()) {
            name = String.valueOf(jType.getEnclosingClass().getSimpleName()) + '$' + jType.getSimpleName();
        }
        return new As3Type(ClassUtil.getPackageName(jType), name);
    }

    protected As3Type getFromCache(Class<?> jType) {
        if (jType == null) {
            throw new NullPointerException("jType must be non null");
        }
        return this.java2As3Type.get(jType);
    }

    protected void putInCache(Class<?> jType, As3Type as3Type) {
        if (jType == null || as3Type == null) {
            throw new NullPointerException("jType and as3Type must be non null");
        }
        this.java2As3Type.put(jType, as3Type);
    }
}

