/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.AbstractTidePersistenceManager;
import org.granite.tide.data.TideTransactionPersistenceManager;

public class JDOPersistenceManager
extends AbstractTidePersistenceManager
implements TideTransactionPersistenceManager {
    protected PersistenceManager pm;

    public JDOPersistenceManager() {
        super(new JDOTransactionManager());
    }

    public JDOPersistenceManager(PersistenceManagerFactory pmf) {
        super(new JDOTransactionManager());
        this.pm = pmf.getPersistenceManager();
    }

    public Object getCurrentTransaction() {
        Transaction t = this.pm.currentTransaction();
        t.begin();
        return t;
    }

    public Object findEntity(Object entity, String[] fetch) {
        Object id = this.pm.getObjectId(entity);
        if (id == null) {
            return null;
        }
        return this.pm.getObjectById(id);
    }

    public static class JDOTransactionManager
    implements TideTransactionManager {
        public Object begin(TideTransactionPersistenceManager pm) {
            if (pm != null) {
                return pm.getCurrentTransaction();
            }
            return null;
        }

        public void commit(Object t) throws Exception {
            ((Transaction)t).commit();
        }

        public void rollback(Object t) {
            ((Transaction)t).rollback();
        }
    }
}

