/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.tide.IUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMergeContext {
    private static ThreadLocal<DataMergeContext> dataMergeContext = new ThreadLocal<DataMergeContext>(){

        @Override
        protected DataMergeContext initialValue() {
            return new DataMergeContext();
        }
    };
    private final Map<Object, Object> cache = new HashMap<Object, Object>();
    private final Map<Object, Object> loadedEntities = new HashMap<Object, Object>();

    public static DataMergeContext get() {
        return dataMergeContext.get();
    }

    public static void remove() {
        dataMergeContext.remove();
    }

    public static Map<Object, Object> getCache() {
        return DataMergeContext.dataMergeContext.get().cache;
    }

    public static void addLoadedEntity(Object entity) {
        DataMergeContext mergeContext = dataMergeContext.get();
        mergeContext.entityLoaded(entity);
    }

    public static void addResultEntity(Object result) {
        DataMergeContext mergeContext = dataMergeContext.get();
        ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        mergeContext.addResultEntity(result, classGetter, new HashSet<Object>());
    }

    public void addResultEntity(Object result, ClassGetter classGetter, Set<Object> cache) {
        if (result == null || cache.contains(result)) {
            return;
        }
        cache.add(result);
        if (classGetter.isEntity(result)) {
            DataMergeContext.addLoadedEntity(result);
        }
        List<Object[]> values = classGetter.getFieldValues(result, result);
        for (Object[] value : values) {
            Object val = value[1];
            if (val == null || val.getClass().isPrimitive() || !classGetter.isInitialized(result, ((Field)value[0]).getName(), val)) continue;
            if (val.getClass().isArray()) {
                int i = 0;
                while (i < Array.getLength(val)) {
                    this.addResultEntity(Array.get(val, i), classGetter, cache);
                    ++i;
                }
                continue;
            }
            if (val instanceof Collection) {
                Iterator i = ((Collection)val).iterator();
                while (i.hasNext()) {
                    this.addResultEntity(i.next(), classGetter, cache);
                }
                continue;
            }
            if (val instanceof Map) {
                for (Map.Entry me : ((Map)val).entrySet()) {
                    this.addResultEntity(me.getKey(), classGetter, cache);
                    this.addResultEntity(me.getValue(), classGetter, cache);
                }
                continue;
            }
            this.addResultEntity(val, classGetter, cache);
        }
    }

    private void entityLoaded(Object entity) {
        Object key = CacheKey.key(entity, null, null);
        Object cachedEntity = this.cache.get(key);
        if (cachedEntity != null) {
            this.cache.clear();
        }
        if (entity instanceof IUID) {
            this.loadedEntities.put(((IUID)entity).getUid(), entity);
        } else {
            this.loadedEntities.put(entity, entity);
        }
    }

    public static Object getLoadedEntity(Object entity) {
        if (entity instanceof IUID) {
            return DataMergeContext.dataMergeContext.get().loadedEntities.get(((IUID)entity).getUid());
        }
        return DataMergeContext.dataMergeContext.get().loadedEntities.get(entity);
    }

    public static Collection<Object> getLoadedEntities() {
        return DataMergeContext.dataMergeContext.get().loadedEntities.values();
    }

    public static void restoreLoadedEntities(Set<Object> loadedEntities) {
        DataMergeContext mergeContext = dataMergeContext.get();
        for (Object entity : loadedEntities) {
            if (entity instanceof IUID) {
                mergeContext.loadedEntities.put(((IUID)entity).getUid(), entity);
                continue;
            }
            mergeContext.loadedEntities.put(entity, entity);
        }
    }

    public static class CacheKey {
        public static Object key(Object obj, Object owner, String propertyName) {
            if (obj instanceof IUID) {
                return new UIDKey(((IUID)obj).getUid());
            }
            if (owner != null && (obj instanceof Collection || obj instanceof Map)) {
                return new CollectionKey(owner, propertyName);
            }
            return obj;
        }
    }

    public static class CollectionKey
    extends CacheKey {
        private Object owner;
        private String propertyName;

        public CollectionKey(Object owner, String propertyName) {
            this.owner = owner;
            this.propertyName = propertyName;
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(CollectionKey.class)) {
                return false;
            }
            return this.owner.equals(((CollectionKey)obj).owner) && this.propertyName.equals(((CollectionKey)obj).propertyName);
        }

        public int hashCode() {
            return this.owner.hashCode() * 31 + this.propertyName.hashCode();
        }
    }

    public static class UIDKey
    extends CacheKey {
        private String uid;

        public UIDKey(String uid) {
            this.uid = uid;
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(UIDKey.class)) {
                return false;
            }
            return this.uid.equals(((UIDKey)obj).uid);
        }

        public int hashCode() {
            return this.uid.hashCode();
        }
    }
}

