/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.data.DataObserveParams;
import org.granite.tide.data.DataPublishParams;
import org.granite.tide.data.DataTopicParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDispatcher {
    private static final Logger log = Logger.getLogger(DataDispatcher.class);
    private boolean enabled = false;
    private String topic = null;
    private DataTopicParams paramsProvider = null;
    private Gravity gravity = null;
    private String sessionId = null;
    private String clientId = null;
    private String subscriptionId = null;

    public DataDispatcher(String topic, Class<? extends DataTopicParams> dataTopicParamsClass) {
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        if (graniteContext == null || !(graniteContext instanceof HttpGraniteContext)) {
            return;
        }
        this.topic = topic;
        try {
            this.paramsProvider = dataTopicParamsClass.newInstance();
        }
        catch (Exception e) {
            log.error("Could not instantiate class " + dataTopicParamsClass, e);
        }
        this.gravity = (Gravity)graniteContext.getApplicationMap().get("org.granite.gravity.Gravity");
        HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
        if (this.gravity == null || session == null) {
            return;
        }
        this.sessionId = session.getId();
        this.clientId = (String)session.getAttribute("org.granite.gravity.channel.clientId." + topic);
        if (this.clientId == null) {
            return;
        }
        this.subscriptionId = (String)session.getAttribute("org.granite.gravity.channel.subscriptionId." + topic);
        if (this.subscriptionId == null) {
            return;
        }
        this.enabled = true;
    }

    public void observe() {
        GraniteContext graniteContext;
        HttpSession session;
        ArrayList<DataObserveParams> selectors;
        DataObserveParams params = null;
        if (this.paramsProvider != null) {
            params = new DataObserveParams();
            this.paramsProvider.observes(params);
        }
        if ((selectors = (ArrayList<DataObserveParams>)(session = ((HttpGraniteContext)(graniteContext = GraniteContext.getCurrentInstance())).getSession(false)).getAttribute("org.granite.tide.dataSelectors." + this.topic)) == null) {
            selectors = new ArrayList<DataObserveParams>();
            session.setAttribute("org.granite.tide.dataSelectors." + this.topic, selectors);
        }
        String dataSelector = (String)session.getAttribute("org.granite.gravity.selector." + this.topic);
        if (params != null && !DataObserveParams.containsParams(selectors, params)) {
            StringBuilder sb = new StringBuilder("type = 'DATA'");
            if (!params.isEmpty()) {
                selectors.add(params);
            }
            if (!selectors.isEmpty()) {
                sb.append(" AND (");
                boolean first = true;
                for (DataObserveParams selector : selectors) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" OR ");
                    }
                    sb.append("(");
                    selector.append(sb);
                    sb.append(")");
                }
                sb.append(")");
            }
            session.setAttribute("org.granite.gravity.selector." + this.topic, (Object)sb.toString());
        } else if (dataSelector == null) {
            dataSelector = "type = 'UNINITIALIZED'";
            session.setAttribute("org.granite.tide.selector." + this.topic, (Object)dataSelector);
        }
        if (!this.enabled) {
            return;
        }
        String clientId = (String)session.getAttribute("org.granite.gravity.channel.clientId." + this.topic);
        if (clientId != null) {
            String subscriptionId = (String)session.getAttribute("org.granite.gravity.channel.subscriptionId." + this.topic);
            CommandMessage message = new CommandMessage();
            message.setClientId(clientId);
            message.setHeader("DSDstClientId", subscriptionId);
            message.setHeader("DSSubtopic", "tideDataTopic");
            message.setDestination(this.topic);
            message.setOperation(0);
            message.setHeader("DSSelector", dataSelector);
            this.gravity.handleMessage(message, true);
        }
    }

    public void publish(Set<Object[]> dataUpdates) {
        if (!this.enabled) {
            return;
        }
        try {
            AsyncMessage message = new AsyncMessage();
            message.setClientId(this.clientId);
            message.setHeader("DSSubtopic", "tideDataTopic");
            message.setDestination(this.topic);
            message.setHeader("org.granite.tide.data.sessionId", this.sessionId);
            message.setHeader("type", "DATA");
            if (this.paramsProvider != null) {
                DataPublishParams params = new DataPublishParams();
                for (Object[] dataUpdate : dataUpdates) {
                    this.paramsProvider.publishes(params, dataUpdate[1]);
                }
                params.setHeaders(message);
            }
            message.setBody(dataUpdates.toArray());
            Channel channel = this.gravity.getChannel(this.clientId);
            this.gravity.publishMessage(channel, message);
        }
        catch (Exception e) {
            log.error(e, "Could not dispatch data update", new Object[0]);
        }
    }
}

