/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.scan.VFSFileScannedItem;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSScanner
implements Scanner {
    private final List<ScannedItemHandler> handlers = new ArrayList<ScannedItemHandler>();
    private final String marker;
    private final ClassLoader loader;

    public VFSScanner(ScannedItemHandler handler) {
        this(handler, null, Thread.currentThread().getContextClassLoader());
    }

    public VFSScanner(ScannedItemHandler handler, String marker) {
        this(handler, marker, Thread.currentThread().getContextClassLoader());
    }

    public VFSScanner(ScannedItemHandler handler, ClassLoader loader) {
        this(handler, null, loader);
    }

    public VFSScanner(ScannedItemHandler handler, String marker, ClassLoader loader) {
        this.marker = marker;
        this.handlers.add(handler);
        this.loader = loader;
    }

    public String getMarker() {
        return this.marker;
    }

    public void addHandler(ScannedItemHandler handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void addHandlers(Collection<ScannedItemHandler> handlers) {
        for (ScannedItemHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    @Override
    public ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public void scan() throws IOException {
        if (this.marker == null) {
            if (!(this.loader instanceof URLClassLoader)) {
                throw new RuntimeException("ClassLoader used with no marker should be a URLClassLoader: " + this.loader);
            }
            URL[] uRLArray = ((URLClassLoader)this.loader).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                VirtualFile root = VFSScanner.getRoot(url, 1);
                if (root != null) {
                    this.handleRoot(null, root);
                }
                ++n2;
            }
        } else {
            Enumeration<URL> urlEnum = this.loader.getResources(this.marker);
            while (urlEnum.hasMoreElements()) {
                URL url = urlEnum.nextElement();
                VirtualFile root = VFSScanner.getRoot(url, this.marker.lastIndexOf(47) > 0 ? 2 : 1);
                if (root == null) continue;
                this.handleRoot(url, root);
            }
        }
    }

    protected void handleRoot(URL markerUrl, VirtualFile root) throws IOException {
        VFSFileScannedItem markerItem = null;
        if (markerUrl != null) {
            VirtualFile markerFile = VFS.getRoot((URL)markerUrl);
            markerItem = new VFSFileScannedItem(this, null, markerFile, markerFile);
            for (ScannedItemHandler scannedItemHandler : this.handlers) {
                scannedItemHandler.handleMarkerItem(markerItem);
            }
        }
        if (root.isLeaf()) {
            for (ScannedItemHandler handler : this.handlers) {
                handler.handleScannedItem(new VFSFileScannedItem(this, markerItem, root, root));
            }
        } else {
            String rootPathName = root.getPathName();
            int n = rootPathName.length();
            List children = root.getChildrenRecursively();
            for (VirtualFile child : children) {
                int length;
                if (!child.isLeaf()) continue;
                String name = child.getPathName();
                if (name.charAt(length = n) == '/') {
                    ++length;
                }
                for (ScannedItemHandler handler : this.handlers) {
                    handler.handleScannedItem(new VFSFileScannedItem(this, markerItem, root, child));
                }
            }
        }
    }

    protected static VirtualFile getRoot(URL url, int parentDepth) throws IOException {
        String relative;
        String urlString = url.toString();
        if (!urlString.startsWith("vfs")) {
            return null;
        }
        int p = urlString.indexOf(":");
        String file = urlString.substring(p + 1);
        URL vfsurl = null;
        File fp = new File(file);
        if (fp.exists()) {
            vfsurl = fp.getParentFile().toURL();
            relative = fp.getName();
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    vfsurl = curr.toURL();
                    break;
                }
                relative = String.valueOf(curr.getName()) + "/" + relative;
            }
        }
        VirtualFile top = VFS.getRoot((URL)vfsurl);
        top = top.getChild(relative);
        while (parentDepth > 0) {
            if (top == null) {
                throw new IllegalArgumentException("Null parent: " + vfsurl + ", relative: " + relative);
            }
            top = top.getParent();
            --parentDepth;
        }
        return top;
    }
}

