/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.InputStream;
import java.util.Properties;
import org.granite.logging.Logger;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.scan.URLScanner;

public class ScannerFactory {
    private static final Logger log = Logger.getLogger(ScannerFactory.class);

    public static Scanner createScanner(ScannedItemHandler handler, String marker) {
        if (ScannerFactory.isVFSAvailable() && !ScannerFactory.isEmbedded() && ScannerFactory.isJBoss5()) {
            log.debug("Using VFS aware scanner", new Object[0]);
            try {
                Class<?> vfsScannerClass = ScannerFactory.class.getClassLoader().loadClass("org.granite.scan.VFSScanner");
                return (Scanner)vfsScannerClass.getConstructor(ScannedItemHandler.class, String.class).newInstance(handler, marker);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create VFSScanner", e);
            }
        }
        log.debug("Using default Scanner", new Object[0]);
        return new URLScanner(handler, marker);
    }

    private static boolean isVFSAvailable() {
        try {
            Class.forName("org.jboss.virtual.VFS");
            log.trace("VFS detected", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isJBoss5() {
        try {
            boolean isJBoss5;
            Properties props = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/org/jboss/version.properties");
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/version.properties");
            }
            props.load(is);
            is.close();
            int major = Integer.parseInt(props.getProperty("version.major"));
            int minor = Integer.parseInt(props.getProperty("version.minor"));
            boolean bl = isJBoss5 = major >= 5 && minor >= 0;
            if (isJBoss5) {
                log.trace("JBoss " + major + "." + minor + " detected", new Object[0]);
            }
            return isJBoss5;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isEmbedded() {
        try {
            Class.forName("org.jboss.embedded.Bootstrap");
            log.trace("JBoss Embedded detected", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

