/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.persistence;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public abstract class AbstractExternalizablePersistentCollection
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Object[] OBJECT_0 = new Object[0];
    protected boolean initialized;
    protected String metadata;
    protected boolean dirty;
    protected Object[] content;

    public AbstractExternalizablePersistentCollection() {
        this(OBJECT_0, true, false);
    }

    public AbstractExternalizablePersistentCollection(Object[] content, boolean initialized, boolean dirty) {
        this.content = content;
        this.initialized = initialized;
        this.dirty = dirty;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Object[] getContent() {
        return this.content;
    }

    public void setContent(Object[] content) {
        this.content = content;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.initialized);
        out.writeObject(this.metadata);
        if (this.initialized) {
            out.writeObject(this.dirty);
            out.writeObject(this.content);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialized = (Boolean)in.readObject();
        this.metadata = (String)in.readObject();
        if (this.initialized) {
            this.dirty = (Boolean)in.readObject();
            Object o = in.readObject();
            if (o != null) {
                this.content = o instanceof Collection ? ((Collection)o).toArray() : (o.getClass().isArray() ? (Object[])o : new Object[]{o});
            }
        }
    }
}

