/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.util.ClassUtil;
import org.granite.util.CollectionUtil;

public class Collection2Collection
extends Converter {
    public Collection2Collection(Converters converters) {
        super(converters);
    }

    protected boolean internalCanConvert(Object value, Type targetType) {
        Type targetComponentType = CollectionUtil.getComponentType(targetType);
        if (targetComponentType == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!(value instanceof Collection)) {
            return false;
        }
        if (targetComponentType.equals(Object.class) || targetComponentType instanceof WildcardType) {
            return true;
        }
        Converter itemConverter = null;
        for (Object item : (Collection)value) {
            if (itemConverter == null) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            } else if (!itemConverter.canConvert(item, targetComponentType)) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            }
            if (itemConverter != null) continue;
            return false;
        }
        return true;
    }

    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            Type targetComponentType = CollectionUtil.getComponentType(targetType);
            if (targetComponentType != null) {
                Class<?> targetClass = ClassUtil.classOfType(targetType);
                if (targetClass.isInstance(value) && (targetComponentType.equals(Object.class) || targetComponentType instanceof WildcardType)) {
                    return value;
                }
                Collection<Object> targetInstance = null;
                try {
                    targetInstance = CollectionUtil.newCollection(targetClass, c.size());
                }
                catch (Exception e) {
                    throw new IllegalConverterArgumentException((Converter)this, value, targetType, e);
                }
                Converter itemConverter = null;
                for (Object item : c) {
                    if (itemConverter == null) {
                        itemConverter = this.converters.getConverter(item, targetComponentType);
                    } else if (!itemConverter.canConvert(item, targetComponentType)) {
                        itemConverter = this.converters.getConverter(item, targetComponentType);
                    }
                    if (itemConverter == null) {
                        throw new IllegalConverterArgumentException(this, value, targetType);
                    }
                    targetInstance.add(itemConverter.convert(item, targetComponentType));
                }
                return targetInstance;
            }
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

